/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.core.block.entity;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.satisfy.farm_and_charm.client.gui.handler.CookingPotGuiHandler;
import net.satisfy.farm_and_charm.core.block.CookingPotBlock;
import net.satisfy.farm_and_charm.core.item.food.EffectFood;
import net.satisfy.farm_and_charm.core.item.food.EffectFoodHelper;
import net.satisfy.farm_and_charm.core.recipe.CookingPotRecipe;
import net.satisfy.farm_and_charm.core.recipe.RecipeUnlockManager;
import net.satisfy.farm_and_charm.core.registry.EntityTypeRegistry;
import net.satisfy.farm_and_charm.core.registry.RecipeTypeRegistry;
import net.satisfy.farm_and_charm.core.registry.TagRegistry;
import net.satisfy.farm_and_charm.core.world.ImplementedInventory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CookingPotBlockEntity
extends BlockEntity
implements BlockEntityTicker<CookingPotBlockEntity>,
ImplementedInventory,
MenuProvider,
Container {
    private static final int FIRST_INGREDIENT_SLOT = 0;
    private static final int LAST_INGREDIENT_SLOT = 5;
    private static final int CONTAINER_SLOT = 6;
    private static final int OUTPUT_SLOT = 7;
    private static final int MAX_CAPACITY = 8;
    private static final int MAX_COOKING_TIME = 900;
    private final NonNullList<ItemStack> inventory = NonNullList.withSize((int)8, (Object)ItemStack.EMPTY);
    private int cookingTime;
    private boolean isBeingBurned;
    private UUID ownerUuid;
    private final ContainerData delegate = new ContainerData(){

        public int get(int index) {
            return switch (index) {
                case 0 -> CookingPotBlockEntity.this.cookingTime;
                case 1 -> {
                    if (CookingPotBlockEntity.this.isBeingBurned) {
                        yield 1;
                    }
                    yield 0;
                }
                default -> 0;
            };
        }

        public void set(int index, int value) {
            switch (index) {
                case 0: {
                    CookingPotBlockEntity.this.cookingTime = value;
                    break;
                }
                case 1: {
                    CookingPotBlockEntity.this.isBeingBurned = value != 0;
                }
            }
        }

        public int getCount() {
            return 2;
        }
    };

    public CookingPotBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)EntityTypeRegistry.COOKING_POT_BLOCK_ENTITY.get(), pos, state);
    }

    public static int getMaxCookingTime() {
        return 900;
    }

    @Override
    public int @NotNull [] getSlotsForFace(Direction side) {
        int[] nArray;
        switch (side) {
            case UP: {
                int[] nArray2 = new int[6];
                nArray2[0] = 0;
                nArray2[1] = 1;
                nArray2[2] = 2;
                nArray2[3] = 3;
                nArray2[4] = 4;
                nArray = nArray2;
                nArray2[5] = 5;
                break;
            }
            case DOWN: {
                int[] nArray3 = new int[1];
                nArray = nArray3;
                nArray3[0] = 7;
                break;
            }
            default: {
                int[] nArray4 = new int[1];
                nArray = nArray4;
                nArray4[0] = 6;
            }
        }
        return nArray;
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        NonNullList loaded = NonNullList.withSize((int)8, (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((CompoundTag)tag, (NonNullList)loaded, (HolderLookup.Provider)provider);
        for (int i = 0; i < 8; ++i) {
            this.inventory.set(i, (Object)((ItemStack)loaded.get(i)));
        }
        this.cookingTime = tag.getInt("CookingTime");
        if (tag.hasUUID("OwnerUUID")) {
            this.ownerUuid = tag.getUUID("OwnerUUID");
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        ContainerHelper.saveAllItems((CompoundTag)tag, this.inventory, (HolderLookup.Provider)provider);
        tag.putInt("CookingTime", this.cookingTime);
        if (this.ownerUuid != null) {
            tag.putUUID("OwnerUUID", this.ownerUuid);
        }
    }

    public boolean isBeingBurned() {
        if (this.level == null) {
            throw new IllegalStateException("Null world not allowed");
        }
        BlockState belowState = this.level.getBlockState(this.worldPosition.below());
        return belowState.is(TagRegistry.ALLOWS_COOKING);
    }

    private boolean canCraft(Recipe<?> recipe, RegistryAccess access) {
        if (recipe == null || recipe.getResultItem((HolderLookup.Provider)access).isEmpty()) {
            return false;
        }
        if (recipe instanceof CookingPotRecipe) {
            ItemStack containerSlotStack;
            CookingPotRecipe cookingRecipe = (CookingPotRecipe)recipe;
            if (cookingRecipe.isContainerRequired() && !(containerSlotStack = this.getItem(6)).is(cookingRecipe.getContainerItem().getItem())) {
                return false;
            }
            ItemStack outputSlotStack = this.getItem(7);
            ItemStack expected = this.generateOutputItem(recipe, access);
            return outputSlotStack.isEmpty() || ItemStack.isSameItemSameComponents((ItemStack)outputSlotStack, (ItemStack)expected) && outputSlotStack.getCount() < outputSlotStack.getMaxStackSize();
        }
        return false;
    }

    private void craft(Recipe<?> recipe, RegistryAccess access) {
        ItemStack containerSlotStack;
        CookingPotRecipe cookingPotRecipe;
        if (!this.canCraft(recipe, access)) {
            return;
        }
        ItemStack recipeOutput = this.generateOutputItem(recipe, access);
        ItemStack outputSlotStack = this.getItem(7);
        if (outputSlotStack.isEmpty()) {
            this.setItem(7, recipeOutput);
        } else {
            outputSlotStack.grow(recipeOutput.getCount());
        }
        recipe.getIngredients().forEach(ingredient -> {
            for (int slot = 0; slot <= 5; ++slot) {
                ItemStack stack = this.getItem(slot);
                if (!ingredient.test(stack)) continue;
                ItemStack remainderStack = stack.getItem().hasCraftingRemainingItem() ? new ItemStack((ItemLike)Objects.requireNonNull(stack.getItem().getCraftingRemainingItem())) : ItemStack.EMPTY;
                stack.shrink(1);
                if (remainderStack.isEmpty()) break;
                this.setItem(slot, remainderStack);
                break;
            }
        });
        if (recipe instanceof CookingPotRecipe && (cookingPotRecipe = (CookingPotRecipe)recipe).isContainerRequired() && !(containerSlotStack = this.getItem(6)).isEmpty()) {
            containerSlotStack.shrink(1);
            if (containerSlotStack.isEmpty()) {
                this.setItem(6, ItemStack.EMPTY);
            }
        }
        this.setChanged();
    }

    private ItemStack generateOutputItem(Recipe<?> recipe, RegistryAccess access) {
        ItemStack outputStack = recipe.getResultItem((HolderLookup.Provider)access).copy();
        if (outputStack.getItem() instanceof EffectFood) {
            for (MobEffectInstance inst : EffectFoodHelper.collectMergedSortedEffects(this, 0, 5)) {
                EffectFoodHelper.addEffect(outputStack, (Pair<MobEffectInstance, Float>)new Pair((Object)inst, (Object)Float.valueOf(1.0f)));
            }
        }
        return outputStack;
    }

    public void tick(Level world, BlockPos pos, BlockState state, CookingPotBlockEntity blockEntity) {
        ServerPlayer owner;
        CookingPotRecipe cookingRecipe;
        CookingPotRecipe cookingPotRecipe;
        if (world.isClientSide()) {
            return;
        }
        boolean wasBeingBurned = this.isBeingBurned;
        this.isBeingBurned = this.isBeingBurned();
        if (wasBeingBurned != this.isBeingBurned || (Boolean)state.getValue((Property)CookingPotBlock.LIT) != this.isBeingBurned) {
            world.setBlock(pos, (BlockState)state.setValue((Property)CookingPotBlock.LIT, (Comparable)Boolean.valueOf(this.isBeingBurned)), 3);
        }
        if (!this.isBeingBurned) {
            return;
        }
        RecipeManager recipeManager = world.getRecipeManager();
        List recipes = recipeManager.getAllRecipesFor((RecipeType)RecipeTypeRegistry.COOKING_POT_RECIPE_TYPE.get());
        Optional<CookingPotRecipe> recipe = Optional.ofNullable(this.getRecipe(recipes, this.inventory));
        if (recipe.isPresent() && (cookingPotRecipe = recipe.get()) instanceof CookingPotRecipe && (cookingRecipe = cookingPotRecipe).requiresLearning() && ((owner = Objects.requireNonNull(world.getServer()).getPlayerList().getPlayer(this.ownerUuid)) == null || RecipeUnlockManager.isRecipeLocked(owner, BuiltInRegistries.RECIPE_TYPE.getKey(recipe.get().getType())))) {
            this.cookingTime = 0;
            if (((Boolean)state.getValue((Property)CookingPotBlock.COOKING)).booleanValue()) {
                world.setBlock(pos, (BlockState)state.setValue((Property)CookingPotBlock.COOKING, (Comparable)Boolean.valueOf(false)), 3);
            }
            return;
        }
        if (this.level == null) {
            throw new IllegalStateException("Null world not allowed");
        }
        RegistryAccess access = this.level.registryAccess();
        if (recipe.isPresent() && this.canCraft(recipe.get(), access)) {
            if (++this.cookingTime >= 900) {
                this.cookingTime = 0;
                this.craft(recipe.get(), access);
            }
            if (!((Boolean)state.getValue((Property)CookingPotBlock.COOKING)).booleanValue()) {
                world.setBlock(pos, (BlockState)state.setValue((Property)CookingPotBlock.COOKING, (Comparable)Boolean.valueOf(true)), 3);
            }
        } else {
            this.cookingTime = 0;
            if (((Boolean)state.getValue((Property)CookingPotBlock.COOKING)).booleanValue()) {
                world.setBlock(pos, (BlockState)state.setValue((Property)CookingPotBlock.COOKING, (Comparable)Boolean.valueOf(false)), 3);
            }
        }
    }

    @Override
    public NonNullList<ItemStack> getItems() {
        return this.inventory;
    }

    @Override
    public void setItem(int slot, ItemStack stack) {
        this.inventory.set(slot, (Object)stack);
        this.setChanged();
    }

    @Override
    public boolean stillValid(Player player) {
        if (this.level == null || this.level.getBlockEntity(this.worldPosition) != this) {
            return false;
        }
        return player.distanceToSqr((double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5) <= 64.0;
    }

    @NotNull
    public Component getDisplayName() {
        return Component.translatable((String)this.getBlockState().getBlock().getDescriptionId());
    }

    private CookingPotRecipe getRecipe(List<RecipeHolder<CookingPotRecipe>> recipes, NonNullList<ItemStack> inventory) {
        for (RecipeHolder<CookingPotRecipe> recipeHolder : recipes) {
            CookingPotRecipe recipe = (CookingPotRecipe)recipeHolder.value();
            if (!this.matchesInventory(recipe, inventory)) continue;
            return recipe;
        }
        return null;
    }

    private boolean matchesInventory(CookingPotRecipe recipe, NonNullList<ItemStack> inventory) {
        NonNullList<Ingredient> ingredients = recipe.getIngredients();
        NonNullList invCopy = NonNullList.withSize((int)inventory.size(), (Object)ItemStack.EMPTY);
        for (int i = 0; i <= 5; ++i) {
            invCopy.set(i, (Object)((ItemStack)inventory.get(i)).copy());
        }
        for (Ingredient ingredient : ingredients) {
            boolean matched = false;
            for (int i = 0; i <= 5; ++i) {
                ItemStack stack = (ItemStack)invCopy.get(i);
                if (stack.isEmpty() || !ingredient.test(stack)) continue;
                stack.shrink(1);
                matched = true;
                break;
            }
            if (matched) continue;
            return false;
        }
        block3: for (int i = 0; i <= 5; ++i) {
            ItemStack remaining = (ItemStack)invCopy.get(i);
            if (remaining.isEmpty()) continue;
            for (Ingredient ingredient : ingredients) {
                if (!ingredient.test(remaining)) continue;
                continue block3;
            }
            return false;
        }
        return true;
    }

    @Nullable
    public AbstractContainerMenu createMenu(int syncId, Inventory inv, Player player) {
        this.ownerUuid = player.getUUID();
        return new CookingPotGuiHandler(syncId, inv, this, this.delegate);
    }
}

