/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.core.block.entity;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.satisfy.farm_and_charm.core.block.CraftingBowlBlock;
import net.satisfy.farm_and_charm.core.recipe.CraftingBowlRecipe;
import net.satisfy.farm_and_charm.core.registry.EntityTypeRegistry;
import net.satisfy.farm_and_charm.core.registry.RecipeTypeRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CraftingBowlBlockEntity
extends RandomizableContainerBlockEntity
implements WorldlyContainer,
BlockEntityTicker<CraftingBowlBlockEntity> {
    private NonNullList<ItemStack> stacks = NonNullList.withSize((int)5, (Object)ItemStack.EMPTY);
    private float whiskAngle;
    private float whiskAnglePrev;
    private float whiskSpeed;
    private float whiskTargetSpeed;

    public CraftingBowlBlockEntity(BlockPos position, BlockState state) {
        super((BlockEntityType)EntityTypeRegistry.CRAFTING_BOWL_BLOCK_ENTITY.get(), position, state);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        if (!this.tryLoadLootTable(tag)) {
            this.stacks = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        }
        ContainerHelper.loadAllItems((CompoundTag)tag, this.stacks, (HolderLookup.Provider)provider);
        this.whiskAngle = tag.getFloat("WhiskAngle");
        this.whiskSpeed = tag.getFloat("WhiskSpeed");
        this.whiskTargetSpeed = tag.getFloat("WhiskTargetSpeed");
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        if (!this.trySaveLootTable(tag)) {
            ContainerHelper.saveAllItems((CompoundTag)tag, this.stacks, (HolderLookup.Provider)provider);
        }
        tag.putFloat("WhiskAngle", this.whiskAngle);
        tag.putFloat("WhiskSpeed", this.whiskSpeed);
        tag.putFloat("WhiskTargetSpeed", this.whiskTargetSpeed);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @NotNull
    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        return this.saveWithoutMetadata(provider);
    }

    public int getContainerSize() {
        return this.stacks.size();
    }

    public boolean isEmpty() {
        for (ItemStack itemstack : this.stacks) {
            if (itemstack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public Component getDefaultName() {
        return Component.literal((String)"crafting_bowl");
    }

    @NotNull
    public AbstractContainerMenu createMenu(int id, Inventory inventory) {
        return ChestMenu.threeRows((int)id, (Inventory)inventory);
    }

    public int getMaxStackSize() {
        return 64;
    }

    public boolean canPlaceItem(int index, ItemStack stack) {
        return index >= 0 && index < 4;
    }

    @NotNull
    public NonNullList<ItemStack> getItems() {
        return this.stacks;
    }

    protected void setItems(NonNullList<ItemStack> stacks) {
        this.stacks = stacks;
    }

    public boolean canAddItem() {
        for (int i = 0; i < 4; ++i) {
            if (!this.getItem(i).isEmpty()) continue;
            return true;
        }
        return false;
    }

    public void addItemStack(ItemStack stack) {
        for (int j = 0; j < 4; ++j) {
            if (!this.getItem(j).isEmpty()) continue;
            ItemStack one = stack.copy();
            one.setCount(1);
            this.setItem(j, one);
            this.setChanged();
            return;
        }
    }

    public int @NotNull [] getSlotsForFace(Direction side) {
        return IntStream.range(0, this.getContainerSize()).toArray();
    }

    public boolean canPlaceItemThroughFace(int index, ItemStack stack, @Nullable Direction direction) {
        return this.canPlaceItem(index, stack);
    }

    public boolean canTakeItemThroughFace(int index, ItemStack stack, Direction direction) {
        return true;
    }

    private ItemStack getRemainderItem(ItemStack stack) {
        if (stack.getItem().hasCraftingRemainingItem()) {
            return new ItemStack((ItemLike)Objects.requireNonNull(stack.getItem().getCraftingRemainingItem()));
        }
        return ItemStack.EMPTY;
    }

    public int getStirringProgress() {
        return (Integer)this.getBlockState().getValue((Property)CraftingBowlBlock.STIRRED);
    }

    public Optional<CraftingBowlRecipe> findRecipe(Level level) {
        if (!this.getItem(4).isEmpty()) {
            return Optional.empty();
        }
        List all = level.getRecipeManager().getAllRecipesFor((RecipeType)RecipeTypeRegistry.CRAFTING_BOWL_RECIPE_TYPE.get());
        return Optional.ofNullable(this.matchExact(all));
    }

    private CraftingBowlRecipe matchExact(List<RecipeHolder<CraftingBowlRecipe>> recipes) {
        ItemStack[] inputs = new ItemStack[4];
        int present = 0;
        for (int i = 0; i < 4; ++i) {
            inputs[i] = this.getItem(i);
            if (inputs[i].isEmpty()) continue;
            ++present;
        }
        for (RecipeHolder<CraftingBowlRecipe> holder : recipes) {
            CraftingBowlRecipe r = (CraftingBowlRecipe)holder.value();
            int needed = 0;
            for (Ingredient ing : r.getIngredients()) {
                if (ing.isEmpty()) continue;
                ++needed;
            }
            if (present != needed) continue;
            boolean[] used = new boolean[4];
            boolean ok = true;
            for (Ingredient ing : r.getIngredients()) {
                if (ing.isEmpty()) continue;
                boolean matched = false;
                for (int i = 0; i < 4; ++i) {
                    if (used[i] || inputs[i].isEmpty() || !ing.test(inputs[i])) continue;
                    used[i] = true;
                    matched = true;
                    break;
                }
                if (matched) continue;
                ok = false;
                break;
            }
            if (!ok) continue;
            return r;
        }
        return null;
    }

    public float getInterpolatedWhiskAngle(float partial) {
        float a0 = this.whiskAnglePrev;
        float a1 = this.whiskAngle;
        float da = a1 - a0;
        float tau = (float)Math.PI * 2;
        if ((double)da > Math.PI) {
            da -= tau;
        }
        if ((double)da < -Math.PI) {
            da += tau;
        }
        return a0 + da * partial;
    }

    public void addWhiskImpulse(float v) {
        this.whiskTargetSpeed = Math.min(0.5f, this.whiskTargetSpeed + v);
    }

    public void tick(Level level, BlockPos pos, BlockState state, CraftingBowlBlockEntity be) {
        this.whiskAnglePrev = this.whiskAngle;
        int stirring = (Integer)state.getValue((Property)CraftingBowlBlock.STIRRING);
        this.whiskTargetSpeed = stirring > 0 ? 0.5f : 0.0f;
        float k = 0.22f;
        this.whiskSpeed += (this.whiskTargetSpeed - this.whiskSpeed) * k;
        if (stirring == 0) {
            this.whiskSpeed *= 0.96f;
        }
        this.whiskAngle += this.whiskSpeed;
        float tau = (float)Math.PI * 2;
        if (this.whiskAngle > tau) {
            this.whiskAngle -= tau;
        }
        if (this.whiskAngle < 0.0f) {
            this.whiskAngle += tau;
        }
        if (!level.isClientSide && state.getBlock() instanceof CraftingBowlBlock) {
            int stirred = (Integer)state.getValue((Property)CraftingBowlBlock.STIRRED);
            if (stirring > 0) {
                Optional<CraftingBowlRecipe> recipe = be.findRecipe(level);
                if (recipe.isPresent() && stirred < 50 && ++stirred == 50) {
                    NonNullList<Ingredient> ings = recipe.get().getIngredients();
                    boolean[] used = new boolean[4];
                    block0: for (Ingredient ing : ings) {
                        if (ing.isEmpty()) continue;
                        for (int i = 0; i < 4; ++i) {
                            if (used[i] || !ing.test(be.getItem(i))) continue;
                            ItemStack stack = be.getItem(i);
                            ItemStack remainder = this.getRemainderItem(stack);
                            stack.shrink(1);
                            if (stack.isEmpty()) {
                                be.setItem(i, ItemStack.EMPTY);
                            }
                            if (!remainder.isEmpty()) {
                                double ox = level.random.nextDouble() * 0.7 + 0.15;
                                double oy = level.random.nextDouble() * 0.7 + 0.15;
                                double oz = level.random.nextDouble() * 0.7 + 0.15;
                                level.addFreshEntity((Entity)new ItemEntity(level, (double)pos.getX() + ox, (double)pos.getY() + oy, (double)pos.getZ() + oz, remainder));
                            }
                            used[i] = true;
                            continue block0;
                        }
                    }
                    ItemStack resultItem = recipe.get().getResultItem((HolderLookup.Provider)level.registryAccess()).copy();
                    resultItem.setCount(recipe.get().getOutputCount());
                    be.setItem(4, resultItem);
                }
                level.setBlock(pos, (BlockState)((BlockState)state.setValue((Property)CraftingBowlBlock.STIRRING, (Comparable)Integer.valueOf(--stirring))).setValue((Property)CraftingBowlBlock.STIRRED, (Comparable)Integer.valueOf(stirred)), 3);
            } else {
                int stirredNow = (Integer)state.getValue((Property)CraftingBowlBlock.STIRRED);
                if (stirredNow > 0 && stirredNow < 50) {
                    level.setBlock(pos, (BlockState)state.setValue((Property)CraftingBowlBlock.STIRRED, (Comparable)Integer.valueOf(0)), 3);
                }
            }
            if (level.getGameTime() % 5L == 0L) {
                this.setChanged();
            }
        }
    }
}

