/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.client.gui;

import io.github.mortuusars.exposure.client.gui.screen.PhotographScreen;
import io.github.mortuusars.exposure.client.gui.screen.album.AlbumViewScreen;
import io.github.mortuusars.exposure.client.util.Minecrft;
import io.github.mortuusars.exposure.world.item.PhotographItem;
import io.github.mortuusars.exposure.world.item.crafting.recipe.FilmDevelopingRecipe;
import io.github.mortuusars.exposure.world.item.crafting.recipe.PhotographCopyingRecipe;
import io.github.mortuusars.exposure.world.item.util.ItemAndStack;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import org.jetbrains.annotations.NotNull;

public class ClientGUI {
    public static void openPhotographScreen(List<ItemAndStack<PhotographItem>> photographs) {
        Minecrft.get().setScreen((Screen)new PhotographScreen(photographs));
    }

    public static void openPhotographsScreenFromItem(int item) {
        Minecrft.get().setScreen((Screen)new PhotographScreen(PhotographScreen.PhotographProvider.fromPhotographItem(item)));
    }

    public static void openAlbumViewScreen(ItemStack albumStack) {
        Minecrft.get().setScreen((Screen)new AlbumViewScreen(AlbumViewScreen.AlbumAccess.fromItem(albumStack)));
    }

    public static void addFilmRollDevelopingTooltip(ItemStack filmStack, Item.TooltipContext tooltipContext, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag isAdvanced) {
        ClientGUI.addRecipeTooltip(filmStack, tooltipContext, tooltipComponents, isAdvanced, r -> {
            FilmDevelopingRecipe filmDevelopingRecipe;
            return r instanceof FilmDevelopingRecipe && (filmDevelopingRecipe = (FilmDevelopingRecipe)((Object)r)).getSourceIngredient().test(filmStack);
        }, "item.exposure.film_roll.tooltip.details.develop");
    }

    public static void addPhotographCopyingTooltip(ItemStack photographStack, Item.TooltipContext tooltipContext, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag isAdvanced) {
        ClientGUI.addRecipeTooltip(photographStack, tooltipContext, tooltipComponents, isAdvanced, r -> {
            PhotographCopyingRecipe photographCopyingRecipe;
            return r instanceof PhotographCopyingRecipe && (photographCopyingRecipe = (PhotographCopyingRecipe)((Object)r)).getSourceIngredient().test(photographStack);
        }, "item.exposure.photograph.tooltip.details.copy");
    }

    private static void addRecipeTooltip(ItemStack stack, Item.TooltipContext tooltipContext, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag isAdvanced, Predicate<CraftingRecipe> recipeFilter, String detailsKey) {
        if (Minecraft.getInstance().level == null) {
            return;
        }
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.exposure.hold_for_details"));
        if (!Screen.hasShiftDown()) {
            return;
        }
        Optional<NonNullList> recipeIngredients = Minecraft.getInstance().level.getRecipeManager().getAllRecipesFor(RecipeType.CRAFTING).stream().map(RecipeHolder::value).filter(recipeFilter).findFirst().map(Recipe::getIngredients);
        if (recipeIngredients.isEmpty() || recipeIngredients.get().isEmpty()) {
            return;
        }
        NonNullList ingredients = recipeIngredients.get();
        tooltipComponents.add((Component)Component.empty());
        Style orange = Style.EMPTY.withColor(13079883);
        Style yellow = Style.EMPTY.withColor(15653496);
        tooltipComponents.add((Component)Component.translatable((String)detailsKey).withStyle(orange));
        for (int i = 0; i < ingredients.size(); ++i) {
            ItemStack[] stacks = ((Ingredient)ingredients.get(i)).getItems();
            if (stacks.length == 0) {
                tooltipComponents.add((Component)Component.literal((String)"  ").append((Component)Component.literal((String)"?").withStyle(yellow)));
                continue;
            }
            if (stacks.length == 1) {
                tooltipComponents.add((Component)Component.literal((String)"  ").append((Component)stacks[0].getHoverName().copy().withStyle(yellow)));
                continue;
            }
            int val = (int)Math.ceil((float)(Minecraft.getInstance().level.getGameTime() + (long)(10 * i)) % (20.0f * (float)stacks.length) / 20.0f);
            int index = Mth.clamp((int)(val - 1), (int)0, (int)(stacks.length - 1));
            tooltipComponents.add((Component)Component.literal((String)"  ").append((Component)stacks[index].getHoverName().copy().withStyle(yellow)));
        }
    }
}

