/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.client.image.modifier.pixel;

import io.github.mortuusars.exposure.client.image.modifier.pixel.PixelEffect;
import io.github.mortuusars.exposure.world.camera.component.ShutterSpeed;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;

public class ExposureEffect
implements PixelEffect {
    protected final float brightness;

    public ExposureEffect(float brightness) {
        this.brightness = brightness;
    }

    public ExposureEffect(float brightnessStops, float brightnessPerStop) {
        this(1.0f + brightnessStops * brightnessPerStop);
    }

    public ExposureEffect(ShutterSpeed shutterSpeed) {
        this(shutterSpeed.getStops(), 0.2f);
    }

    @Override
    public String getIdentifier() {
        return "brightness-" + this.brightness;
    }

    @Override
    public int modify(int colorARGB) {
        float bias;
        if (this.brightness == 1.0f) {
            return colorARGB;
        }
        int alpha = FastColor.ARGB32.alpha((int)colorARGB);
        int red = FastColor.ARGB32.red((int)colorARGB);
        int green = FastColor.ARGB32.green((int)colorARGB);
        int blue = FastColor.ARGB32.blue((int)colorARGB);
        float lightness = (float)(blue + green + red) / 765.0f;
        if (this.brightness < 1.0f) {
            bias = (1.0f - lightness) * 0.8f + 0.2f;
        } else {
            float curve = (float)Math.pow(Math.sin((double)lightness * Math.PI), 2.0);
            bias = lightness > 0.5f ? curve * 0.8f + 0.2f : curve * 0.5f + 0.5f;
        }
        float b = Mth.lerp((float)bias, (float)blue, (float)((float)blue * this.brightness));
        float g = Mth.lerp((float)bias, (float)green, (float)((float)green * this.brightness));
        float r = Mth.lerp((float)bias, (float)red, (float)((float)red * this.brightness));
        int[] rdst = this.redistribute(r, g, b);
        return FastColor.ARGB32.color((int)alpha, (int)Mth.clamp((int)Mth.lerpInt((float)0.5f, (int)((int)r), (int)rdst[0]), (int)0, (int)255), (int)Mth.clamp((int)Mth.lerpInt((float)0.5f, (int)((int)g), (int)rdst[1]), (int)0, (int)255), (int)Mth.clamp((int)Mth.lerpInt((float)0.5f, (int)((int)b), (int)rdst[2]), (int)0, (int)255));
    }

    private int[] redistribute(float red, float green, float blue) {
        float threshold = 255.999f;
        float max = Math.max(red, Math.max(green, blue));
        if (max <= threshold) {
            return new int[]{Mth.clamp((int)Math.round(red), (int)0, (int)255), Mth.clamp((int)Math.round(green), (int)0, (int)255), Mth.clamp((int)Math.round(blue), (int)0, (int)255)};
        }
        float total = red + green + blue;
        if (total >= 3.0f * threshold) {
            return new int[]{(int)threshold, (int)threshold, (int)threshold};
        }
        float x = (3.0f * threshold - total) / (3.0f * max - total);
        float gray = threshold - x * max;
        return new int[]{Mth.clamp((int)Math.round(gray + x * red), (int)0, (int)255), Mth.clamp((int)Math.round(gray + x * green), (int)0, (int)255), Mth.clamp((int)Math.round(gray + x * blue), (int)0, (int)255)};
    }

    public String toString() {
        return "BrightnessProcessor[brightness=" + this.brightness + "]";
    }
}

