/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.client.util;

import io.github.mortuusars.exposure.Exposure;
import java.io.File;
import java.nio.file.Path;
import net.minecraft.client.Minecraft;

public class LevelNameGetter {
    public static String getWorldName() {
        try {
            if (Minecraft.getInstance().isSingleplayer()) {
                if (Minecraft.getInstance().getSingleplayerServer() != null) {
                    return Minecraft.getInstance().getSingleplayerServer().getWorldData().getLevelName().replace('.', '_');
                }
                String gameDirectory = Minecraft.getInstance().gameDirectory.getAbsolutePath();
                Path savesDir = Path.of(gameDirectory, "/saves");
                File[] dirs = savesDir.toFile().listFiles((dir, name) -> new File(dir, name).isDirectory());
                if (dirs == null || dirs.length == 0) {
                    return "";
                }
                File lastModified = dirs[0];
                for (File dir2 : dirs) {
                    if (dir2.lastModified() <= lastModified.lastModified()) continue;
                    lastModified = dir2;
                }
                return lastModified.getName();
            }
            if (Minecraft.getInstance().getCurrentServer() != null) {
                return Minecraft.getInstance().getCurrentServer().name;
            }
            return "Unknown";
        }
        catch (Exception e) {
            Exposure.LOGGER.error("Failed to get level name: " + String.valueOf(e));
            return "Unknown";
        }
    }
}

