/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.world.item.component.album;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.mortuusars.exposure.world.item.component.album.SignedAlbumPage;
import java.util.Collections;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public record SignedAlbumContent(String title, String author, List<SignedAlbumPage> pages) {
    public static final Codec<SignedAlbumContent> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("title").forGetter(SignedAlbumContent::title), (App)Codec.STRING.fieldOf("author").forGetter(SignedAlbumContent::author), (App)SignedAlbumPage.CODEC.sizeLimitedListOf(16).fieldOf("pages").forGetter(SignedAlbumContent::pages)).apply((Applicative)instance, SignedAlbumContent::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, SignedAlbumContent> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, SignedAlbumContent::title, (StreamCodec)ByteBufCodecs.STRING_UTF8, SignedAlbumContent::author, (StreamCodec)SignedAlbumPage.STREAM_CODEC.apply(ByteBufCodecs.list((int)16)), SignedAlbumContent::pages, SignedAlbumContent::new);
    public static final SignedAlbumContent EMPTY = new SignedAlbumContent("", "", Collections.emptyList());

    public SignedAlbumContent {
        Preconditions.checkArgument((pages.size() <= 16 ? 1 : 0) != 0, (Object)"Too many pages for signed album. Max is 16");
    }
}

