/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.client.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import com.st0x0ef.stellaris.client.screens.GUISprites;
import com.st0x0ef.stellaris.client.screens.components.FluidGaugeWidget;
import com.st0x0ef.stellaris.client.screens.components.GaugeWidget;
import com.st0x0ef.stellaris.common.blocks.entities.machines.FluidTankBlockEntity;
import com.st0x0ef.stellaris.common.menus.FluidTankMenu;
import com.st0x0ef.stellaris.common.utils.ResourceLocationUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class FluidTankScreen
extends AbstractContainerScreen<FluidTankMenu> {
    private static final ResourceLocation TEXTURE = ResourceLocationUtils.guiTexture("fluid_tank");
    private final FluidTankBlockEntity blockEntity = ((FluidTankMenu)this.getMenu()).getBlockEntity();
    private FluidGaugeWidget fluidGauge;

    public FluidTankScreen(FluidTankMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.imageWidth = 180;
        this.imageHeight = 188;
        this.titleLabelX = (180 - Minecraft.getInstance().font.width(title.getString())) / 2;
        this.titleLabelY = 2;
    }

    protected void init() {
        super.init();
        if (this.blockEntity == null) {
            return;
        }
        MutableComponent tooltip = this.blockEntity.getFluidTank().isEmpty() ? Component.translatable((String)"stellaris.screen.empty_fluid") : this.blockEntity.getFluidTank().getFluidInTank(0).getName();
        this.fluidGauge = new FluidGaugeWidget(this.leftPos + 84, this.topPos + 36, 12, 46, (Component)tooltip, this.blockEntity::getFluidTank, 0, GaugeWidget.Direction4.DOWN_UP).setOverlaySprite(GUISprites.FLUID_TANK_OVERLAY);
        this.addRenderableWidget((GuiEventListener)this.fluidGauge);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        guiGraphics.blit(TEXTURE, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, this.imageWidth, this.imageHeight);
    }

    protected void renderTooltip(GuiGraphics guiGraphics, int x, int y) {
        super.renderTooltip(guiGraphics, x, y);
        MutableComponent tooltip = this.blockEntity.getFluidTank().isEmpty() ? Component.translatable((String)"stellaris.screen.empty_fluid") : this.blockEntity.getFluidTank().getFluidInTank(0).getName();
        this.fluidGauge.setMessage((Component)tooltip);
        this.fluidGauge.renderTooltip(guiGraphics, x, y, this.font);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, this.title, this.titleLabelX, this.titleLabelY, 5726575, false);
    }
}

