/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.client.screens.components;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.MultiLineTextWidget;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class CustomCheckBox
extends AbstractButton {
    private ResourceLocation texture = ResourceLocation.withDefaultNamespace((String)"widget/checkbox_selected");
    private ResourceLocation checkTexture = ResourceLocation.withDefaultNamespace((String)"widget/checkbox");
    public boolean selected;
    private final OnValueChange onValueChange;
    private final MultiLineTextWidget textWidget;
    private boolean text = true;

    public CustomCheckBox(int x, int y, int maxWidth, Component message, Font font, boolean selected) {
        this(x, y, maxWidth, message, font, selected, OnValueChange.NOP);
    }

    public CustomCheckBox(int x, int y, int maxWidth, Component message, Font font, boolean selected, OnValueChange onValueChange) {
        super(x, y, 0, 0, message);
        this.width = maxWidth;
        this.textWidget = new MultiLineTextWidget(message, font).setMaxWidth(this.width).setColor(0xE0E0E0);
        this.height = this.width;
        this.selected = selected;
        this.onValueChange = onValueChange;
    }

    public CustomCheckBox showText(boolean text) {
        this.text = text;
        return this;
    }

    public CustomCheckBox setTexture(ResourceLocation texture, ResourceLocation checkTexture) {
        this.texture = texture;
        this.checkTexture = checkTexture;
        return this;
    }

    private int getAdjustedWidth(int maxWidth, Component message, Font font) {
        return Math.min(CustomCheckBox.getDefaultWidth(message, font), maxWidth);
    }

    private int getAdjustedHeight(Font font) {
        return Math.max(CustomCheckBox.getBoxSize(font), this.textWidget.getHeight());
    }

    static int getDefaultWidth(Component message, Font font) {
        return CustomCheckBox.getBoxSize(font) + 4 + font.width((FormattedText)message);
    }

    public static int getBoxSize(Font font) {
        Objects.requireNonNull(font);
        return 17;
    }

    public void onPress() {
        this.selected = !this.selected;
        this.onValueChange.onValueChange(this, this.selected);
    }

    public CustomCheckBox setSelected(boolean selected) {
        this.selected = selected;
        return this;
    }

    public void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
        narrationElementOutput.add(NarratedElementType.TITLE, (Component)this.createNarrationMessage());
        if (this.active) {
            if (this.isFocused()) {
                narrationElementOutput.add(NarratedElementType.USAGE, (Component)Component.translatable((String)"narration.checkbox.usage.focused"));
            } else {
                narrationElementOutput.add(NarratedElementType.USAGE, (Component)Component.translatable((String)"narration.checkbox.usage.hovered"));
            }
        }
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        Minecraft minecraft = Minecraft.getInstance();
        RenderSystem.enableDepthTest();
        Font font = minecraft.font;
        guiGraphics.setColor(1.0f, 1.0f, 1.0f, this.alpha);
        RenderSystem.enableBlend();
        ResourceLocation resourceLocation = this.selected ? this.checkTexture : this.texture;
        int i = this.width;
        guiGraphics.blitSprite(resourceLocation, this.getX(), this.getY(), i, i);
        if (this.text) {
            int j = this.getX() + i + 4;
            int k = this.getY() + i / 2 - this.textWidget.getHeight() / 2;
            this.textWidget.setPosition(j, k);
            this.textWidget.renderWidget(guiGraphics, mouseX, mouseY, partialTick);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface OnValueChange {
        public static final OnValueChange NOP = (checkbox, bl) -> {};

        public void onValueChange(CustomCheckBox var1, boolean var2);
    }
}

