/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.blocks.entities.machines;

import com.st0x0ef.stellaris.common.blocks.entities.ImplementedInventory;
import com.st0x0ef.stellaris.common.blocks.entities.machines.TickingBlockEntity;
import com.st0x0ef.stellaris.common.launchpads.LaunchPad;
import com.st0x0ef.stellaris.common.menus.AntennaMenu;
import com.st0x0ef.stellaris.common.network.packets.LaunchPadsOperations;
import com.st0x0ef.stellaris.common.registry.BlockEntityRegistry;
import dev.architectury.networking.NetworkManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class AntennaBlockEntity
extends BaseContainerBlockEntity
implements ImplementedInventory,
TickingBlockEntity {
    public int launchPadId = -1;
    private NonNullList<ItemStack> items = NonNullList.withSize((int)3, (Object)ItemStack.EMPTY);

    public AntennaBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)BlockEntityRegistry.ANTENNA.get(), blockPos, blockState);
    }

    @NotNull
    protected Component getDefaultName() {
        return Component.literal((String)"Launch Pad Creator");
    }

    protected void setItems(NonNullList<ItemStack> items) {
        this.items = items;
    }

    protected AbstractContainerMenu createMenu(int containerId, Inventory inventory) {
        return new AntennaMenu(containerId, inventory, this, this.launchPadId);
    }

    @Override
    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    @Override
    public int getContainerSize() {
        return 0;
    }

    @Override
    public void setChanged() {
        if (this.level != null) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
            super.setChanged();
        }
    }

    public void loadAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        super.loadAdditional(compoundTag, provider);
        this.launchPadId = compoundTag.getInt("LaunchPadId");
        this.items = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((CompoundTag)compoundTag, this.items, (HolderLookup.Provider)provider);
    }

    protected void saveAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        super.saveAdditional(compoundTag, provider);
        compoundTag.putInt("LaunchPadId", this.launchPadId);
        ContainerHelper.saveAllItems((CompoundTag)compoundTag, this.items, (HolderLookup.Provider)provider);
    }

    public void setLaunchPad(LaunchPad launchPad, boolean create) {
        if (this.level == null || !this.level.isClientSide) {
            this.launchPadId = launchPad.id();
            return;
        }
        if (create) {
            NetworkManager.sendToServer((CustomPacketPayload)new LaunchPadsOperations(launchPad, "add"));
        }
        this.launchPadId = launchPad.id();
        NetworkManager.sendToServer((CustomPacketPayload)new LaunchPadsOperations(launchPad, "setLaunchPad"));
    }

    @Override
    public void tick() {
    }
}

