/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.blocks.entities.machines;

import com.fej1fun.potentials.providers.EnergyProvider;
import com.st0x0ef.stellaris.common.blocks.entities.machines.TickingBlockEntity;
import com.st0x0ef.stellaris.common.network.packets.SyncEnergyPacketWithoutDirection;
import com.st0x0ef.stellaris.common.utils.capabilities.energy.EnergyStorage;
import dev.architectury.networking.NetworkManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseEnergyBlockEntity
extends BlockEntity
implements EnergyProvider.BLOCK,
TickingBlockEntity {
    @NotNull
    protected EnergyStorage energyContainer;

    public BaseEnergyBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, int maxCapacity, int maxInput, int maxOutput) {
        super(type, pos, state);
        this.energyContainer = new EnergyStorage(maxCapacity, maxInput, maxOutput){

            @Override
            protected void onChange() {
                BaseEnergyBlockEntity.this.setChanged();
                if (BaseEnergyBlockEntity.this.level != null && BaseEnergyBlockEntity.this.level.getServer() != null && !BaseEnergyBlockEntity.this.level.getServer().getPlayerList().getPlayers().isEmpty()) {
                    NetworkManager.sendToPlayers((Iterable)BaseEnergyBlockEntity.this.level.getServer().getPlayerList().getPlayers(), (CustomPacketPayload)new SyncEnergyPacketWithoutDirection(BaseEnergyBlockEntity.this.energyContainer.getEnergy(), BaseEnergyBlockEntity.this.getBlockPos()));
                }
            }
        };
    }

    public BaseEnergyBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, int maxCapacity) {
        this(type, pos, state, maxCapacity, maxCapacity, maxCapacity);
    }

    @NotNull
    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        this.saveAdditional(tag, provider);
        return tag;
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.energyContainer.load(tag, "base");
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        this.energyContainer.save(tag, "base");
    }

    @Nullable
    public EnergyStorage getEnergy(@Nullable Direction direction) {
        return this.energyContainer;
    }
}

