/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.blocks.entities.machines;

import com.fej1fun.potentials.components.FluidAmountMapDataComponent;
import com.fej1fun.potentials.fluid.UniversalFluidStorage;
import com.fej1fun.potentials.providers.FluidProvider;
import com.st0x0ef.stellaris.Stellaris;
import com.st0x0ef.stellaris.common.blocks.entities.machines.BaseGeneratorBlockEntity;
import com.st0x0ef.stellaris.common.blocks.machines.DieselGeneratorBlock;
import com.st0x0ef.stellaris.common.menus.DieselGeneratorMenu;
import com.st0x0ef.stellaris.common.network.packets.SyncFluidPacketWithoutDirection;
import com.st0x0ef.stellaris.common.registry.BlockEntityRegistry;
import com.st0x0ef.stellaris.common.registry.FluidRegistry;
import com.st0x0ef.stellaris.common.utils.capabilities.energy.EnergyUtil;
import com.st0x0ef.stellaris.common.utils.capabilities.fluid.FluidUtil;
import com.st0x0ef.stellaris.common.utils.capabilities.fluid.SingleFluidStorage;
import dev.architectury.fluid.FluidStack;
import dev.architectury.networking.NetworkManager;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.Nullable;

public class DieselGeneratorBlockEntity
extends BaseGeneratorBlockEntity
implements FluidProvider.BLOCK {
    private int litTime;
    private int litDuration;
    private final SingleFluidStorage dieselTank = new SingleFluidStorage(12800L, 12800L, 12800L){

        @Override
        protected void onChange() {
            DieselGeneratorBlockEntity.this.setChanged();
            if (DieselGeneratorBlockEntity.this.level != null && DieselGeneratorBlockEntity.this.level.getServer() != null && !DieselGeneratorBlockEntity.this.level.getServer().getPlayerList().getPlayers().isEmpty()) {
                NetworkManager.sendToPlayers((Iterable)DieselGeneratorBlockEntity.this.level.getServer().getPlayerList().getPlayers(), (CustomPacketPayload)new SyncFluidPacketWithoutDirection(new FluidAmountMapDataComponent(List.of(this.getFluidInTank(0).getFluid()), List.of(Long.valueOf(this.getFluidValueInTank()))), 0, DieselGeneratorBlockEntity.this.getBlockPos()));
            }
        }

        @Override
        public boolean isFluidValid(int tank, FluidStack stack) {
            return stack.getFluid().isSame((Fluid)FluidRegistry.DIESEL_STILL.get());
        }
    };

    public DieselGeneratorBlockEntity(BlockPos blockPos, BlockState blockState) {
        this(BlockEntityRegistry.DIESEL_GENERATOR.get(), blockPos, blockState, 10, 12800);
    }

    public DieselGeneratorBlockEntity(BlockEntityType<?> entityType, BlockPos blockPos, BlockState blockState, int energyGeneratedPT, int maxCapacity) {
        super(entityType, blockPos, blockState, energyGeneratedPT, maxCapacity);
    }

    protected AbstractContainerMenu createMenu(int containerId, Inventory inventory) {
        return new DieselGeneratorMenu(containerId, inventory, (Container)this, this);
    }

    @Override
    public void tick() {
        boolean wasLit = this.isLit();
        boolean shouldUpdate = false;
        if (this.canGenerate()) {
            --this.litTime;
        }
        FluidUtil.moveFluidFromItem(0, 0, (NonNullList<ItemStack>)this.items, this.dieselTank, 1000L);
        if (!this.dieselTank.isEmpty() && this.litTime <= 0) {
            int fuelTime;
            this.litDuration = fuelTime = Stellaris.CONFIG.dieselGeneratorFuelTime;
            this.litTime = fuelTime;
            if (this.isLit()) {
                this.dieselTank.drain(FluidStack.create((Fluid)((Fluid)FluidRegistry.DIESEL_STILL.get()), (long)5L), false);
                this.energyContainer.insert(this.energyGeneratedPT, false);
                shouldUpdate = true;
            }
        }
        if (wasLit != this.isLit()) {
            shouldUpdate = true;
            BlockState state = (BlockState)this.getBlockState().setValue((Property)DieselGeneratorBlock.LIT, (Comparable)Boolean.valueOf(this.isLit()));
            this.level.setBlock(this.getBlockPos(), state, 3);
        }
        if (shouldUpdate) {
            this.setChanged();
        }
        EnergyUtil.distributeEnergyNearby(this.level, this.worldPosition, this.maxCapacity);
    }

    private boolean isLit() {
        return this.litTime > 0;
    }

    @Override
    public boolean canGenerate() {
        boolean isMaxEnergy = this.energyContainer.getEnergy() == this.energyContainer.getMaxEnergy();
        return this.isLit() && !isMaxEnergy;
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.litTime = tag.getShort("BurnTime");
        this.dieselTank.load(tag, provider, "diesel");
    }

    @Override
    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.putShort("BurnTime", (short)this.litTime);
        this.dieselTank.save(tag, provider, "diesel");
    }

    protected Component getDefaultName() {
        return Component.translatable((String)"block.stellaris.diesel_generator");
    }

    @Override
    public int getContainerSize() {
        return 2;
    }

    public SingleFluidStorage getDieselTank() {
        return this.dieselTank;
    }

    @Nullable
    public UniversalFluidStorage getFluidTank(@Nullable Direction direction) {
        return this.dieselTank;
    }
}

