/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.blocks.machines;

import com.mojang.serialization.MapCodec;
import com.st0x0ef.stellaris.common.blocks.entities.machines.AntennaBlockEntity;
import com.st0x0ef.stellaris.common.blocks.machines.BaseMachineBlock;
import com.st0x0ef.stellaris.common.launchpads.LaunchPadUtils;
import com.st0x0ef.stellaris.common.menus.AntennaMenu;
import com.st0x0ef.stellaris.common.registry.BlockEntityRegistry;
import dev.architectury.registry.menu.ExtendedMenuProvider;
import io.netty.buffer.Unpooled;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AntennaBlock
extends BaseMachineBlock {
    public AntennaBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new AntennaBlockEntity(pos, state);
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return super.getStateForPlacement(context);
    }

    @Override
    public BlockEntityType<?> getBlockEntityType() {
        return (BlockEntityType)BlockEntityRegistry.ANTENNA.get();
    }

    @Override
    public boolean hasTicker(Level level) {
        return !level.isClientSide;
    }

    @NotNull
    protected MapCodec<? extends BaseEntityBlock> codec() {
        return AntennaBlock.simpleCodec(AntennaBlock::new);
    }

    @Override
    @Nullable
    protected ExtendedMenuProvider getMenuProvider(BlockState state, Level level, BlockPos pos) {
        final BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof AntennaBlockEntity) {
            final AntennaBlockEntity padCreatorBlock = (AntennaBlockEntity)blockEntity;
            return new ExtendedMenuProvider(){

                public void saveExtraData(FriendlyByteBuf buf) {
                    buf.writeBlockPos(blockEntity.getBlockPos());
                    buf.writeInt(padCreatorBlock.launchPadId);
                }

                public Component getDisplayName() {
                    return padCreatorBlock.getDisplayName();
                }

                public AbstractContainerMenu createMenu(int containerId, Inventory inventory, Player player) {
                    FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
                    buf.writeBlockPos(blockEntity.getBlockPos());
                    buf.writeInt(padCreatorBlock.launchPadId);
                    return AntennaMenu.create(containerId, inventory, buf);
                }
            };
        }
        return null;
    }

    @Override
    @NotNull
    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        BlockEntity blockEntity;
        if (!level.isClientSide && (blockEntity = level.getBlockEntity(pos)) instanceof AntennaBlockEntity) {
            AntennaBlockEntity antennaBlock = (AntennaBlockEntity)blockEntity;
            if (antennaBlock.launchPadId == -1 || LaunchPadUtils.getPadById(antennaBlock.launchPadId).owner().equals(player.getDisplayName().getString())) {
                super.useWithoutItem(state, level, pos, player, hitResult);
            } else {
                player.sendSystemMessage((Component)Component.translatable((String)"message.stellaris.not_owner_of_launch_pad"));
            }
        }
        return InteractionResult.SUCCESS;
    }
}

