/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.data.screen;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.st0x0ef.stellaris.Stellaris;
import com.st0x0ef.stellaris.client.events.custom.PlanetSelectionClientEvents;
import com.st0x0ef.stellaris.client.screens.GalaxyScreen;
import com.st0x0ef.stellaris.client.screens.info.GalaxyInfo;
import com.st0x0ef.stellaris.client.screens.record.GalaxyRecord;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GalaxyPack
extends SimpleJsonResourceReloadListener {
    public static final Map<String, GalaxyRecord> GALAXY = new HashMap<String, GalaxyRecord>();

    public GalaxyPack() {
        super(Stellaris.GSON, "renderer/planet_screen/galaxy");
    }

    protected void apply(Map<ResourceLocation, JsonElement> object, ResourceManager resourceManager, ProfilerFiller profiler) {
        object.forEach((key, value) -> {
            JsonObject json = GsonHelper.convertToJsonObject((JsonElement)value, (String)"galaxy");
            GalaxyRecord galaxy = (GalaxyRecord)GalaxyRecord.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow();
            GALAXY.putIfAbsent(galaxy.name(), galaxy);
            GalaxyInfo screenGalaxy = new GalaxyInfo(galaxy.texture(), galaxy.name(), galaxy.translatable(), galaxy.id(), galaxy.centerStar());
            if (!GalaxyScreen.GALAXY.contains(screenGalaxy)) {
                GalaxyScreen.GALAXY.add(screenGalaxy);
            }
            Stellaris.LOG.info("Added galaxy '{}' to GalaxyScreen: {}", (Object)galaxy.name(), (Object)galaxy.id());
        });
        Stellaris.LOG.info("Finished loading {} galaxies.", (Object)GalaxyScreen.GALAXY.size());
        ((PlanetSelectionClientEvents.PostGalaxyPackRegistryEvent)PlanetSelectionClientEvents.POST_GALAXY_PACK_REGISTRY.invoker()).galaxyRegistered(GalaxyScreen.GALAXY);
    }
}

