/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.entities.vehicles;

import com.st0x0ef.stellaris.Stellaris;
import com.st0x0ef.stellaris.common.entities.vehicles.base.IVehicleEntity;
import com.st0x0ef.stellaris.common.keybinds.KeyVariables;
import com.st0x0ef.stellaris.common.menus.LanderMenu;
import com.st0x0ef.stellaris.common.registry.EntityRegistry;
import dev.architectury.registry.menu.ExtendedMenuProvider;
import dev.architectury.registry.menu.MenuRegistry;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HasCustomInventoryScreen;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class LanderEntity
extends IVehicleEntity
implements HasCustomInventoryScreen {
    protected SimpleContainer inventory = new SimpleContainer(15);

    public LanderEntity(Level level) {
        this((EntityType<? extends LanderEntity>)((EntityType)EntityRegistry.LANDER.get()), level);
    }

    public LanderEntity(EntityType<? extends LanderEntity> type, Level level) {
        super(type, level);
    }

    public boolean isPushable() {
        return false;
    }

    public boolean canBeCollidedWith() {
        return true;
    }

    public void push(Entity p_21294_) {
    }

    public Vec3 getPassengerRidingPosition(Entity entity) {
        return this.position().add(this.getPassengerAttachmentPoint(entity, this.getDimensions(this.getPose()), 1.0f)).add(0.0, 2.0, 0.0);
    }

    public void kill() {
        this.dropEquipment();
        if (!this.level().isClientSide) {
            this.remove(Entity.RemovalReason.DISCARDED);
        }
    }

    public boolean hurt(DamageSource source, float amount) {
        if (source.getEntity() != null && source.getEntity().isCrouching() && !this.isVehicle()) {
            this.dropEquipment();
            if (!this.level().isClientSide) {
                this.remove(Entity.RemovalReason.DISCARDED);
            }
            return true;
        }
        return false;
    }

    public boolean causeFallDamage(float fallDistance, float multiplier, DamageSource source) {
        if (fallDistance > 5.0f && !this.level().isClientSide && Stellaris.CONFIG.landerExplodeWhenTooFast) {
            this.level().explode((Entity)this, this.getX(), this.getY(), this.getZ(), 10.0f, true, Level.ExplosionInteraction.TNT);
            this.remove(Entity.RemovalReason.DISCARDED);
        }
        return super.causeFallDamage(fallDistance, multiplier, source);
    }

    protected void dropEquipment() {
        for (int i = 0; i < this.inventory.getItems().size(); ++i) {
            ItemStack itemstack = this.inventory.getItem(i);
            if (itemstack.isEmpty()) continue;
            this.spawnAtLocation(itemstack);
        }
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        compound.put("InventoryCustom", (Tag)this.inventory.createTag((HolderLookup.Provider)this.registryAccess()));
        ListTag listTag = new ListTag();
        for (int i = 1; i < this.inventory.getContainerSize(); ++i) {
            ItemStack itemStack = this.inventory.getItem(i);
            if (itemStack.isEmpty()) continue;
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.putByte("Slot", (byte)(i - 1));
            listTag.add((Object)itemStack.save((HolderLookup.Provider)this.registryAccess(), (Tag)compoundTag));
        }
        compound.put("Items", (Tag)listTag);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        ListTag inventoryCustom = compound.getList("InventoryCustom", 15);
        this.inventory.fromTag(inventoryCustom, (HolderLookup.Provider)this.registryAccess());
        ListTag listTag = compound.getList("Items", 10);
        for (int i = 0; i < listTag.size(); ++i) {
            CompoundTag compoundTag = listTag.getCompound(i);
            int j = compoundTag.getByte("Slot") & 0xFF;
            if (j >= this.inventory.getContainerSize() - 1) continue;
            this.inventory.setItem(j + 1, ItemStack.parse((HolderLookup.Provider)this.registryAccess(), (Tag)compoundTag).orElse(ItemStack.EMPTY));
        }
    }

    @Override
    @NotNull
    public InteractionResult interact(Player player, InteractionHand hand) {
        super.interact(player, hand);
        InteractionResult result = InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        if (!this.level().isClientSide) {
            if (player.isCrouching()) {
                this.openCustomInventoryScreen(player);
                return InteractionResult.CONSUME;
            }
            player.startRiding((Entity)this);
            return InteractionResult.CONSUME;
        }
        return result;
    }

    @Override
    public void tick() {
        super.tick();
        if (KeyVariables.isHoldingJump(this.getFirstPlayerPassenger())) {
            this.slowDownLander();
        }
    }

    public Player getFirstPlayerPassenger() {
        Object e;
        if (!this.getPassengers().isEmpty() && (e = this.getPassengers().getFirst()) instanceof Player) {
            Player player = (Player)e;
            return player;
        }
        return null;
    }

    public void slowDownLander() {
        Vec3 vec = this.getDeltaMovement();
        if (!this.onGround()) {
            if (vec.y() < -0.05) {
                this.setDeltaMovement(vec.x(), vec.y() * 0.75, vec.z());
            }
            this.fallDistance = (float)(vec.y() * -1.0 * 4.5);
            Level level = this.level();
            if (level instanceof ServerLevel) {
                ServerLevel level2 = (ServerLevel)level;
                for (ServerPlayer player : level2.getServer().getPlayerList().getPlayers()) {
                    level2.sendParticles(player, (ParticleOptions)ParticleTypes.SPIT, true, this.getX(), this.getY() - 0.3, this.getZ(), 3, 0.1, 0.1, 0.1, 0.001);
                }
            }
        }
    }

    public void openCustomInventoryScreen(Player player) {
        MenuRegistry.openExtendedMenu((ServerPlayer)((ServerPlayer)player), (ExtendedMenuProvider)new ExtendedMenuProvider(){

            public void saveExtraData(FriendlyByteBuf buf) {
            }

            public Component getDisplayName() {
                return Component.translatable((String)"container.entity.stellaris.lander");
            }

            public AbstractContainerMenu createMenu(int id, Inventory playerInv, Player player) {
                return new LanderMenu(id, playerInv, (Container)LanderEntity.this.inventory);
            }
        });
    }

    public Container getInventory() {
        return this.inventory;
    }
}

