/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.items;

import com.fej1fun.potentials.energy.ItemEnergyStorage;
import com.fej1fun.potentials.energy.UniversalEnergyStorage;
import com.fej1fun.potentials.providers.EnergyProvider;
import com.st0x0ef.stellaris.common.registry.DataComponentsRegistry;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BatteryItem
extends Item
implements EnergyProvider.ITEM {
    public BatteryItem(Item.Properties properties) {
        super(properties);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        UniversalEnergyStorage energy = this.getEnergy(stack);
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.item.stellaris.energy", (Object[])new Object[]{energy.getEnergy(), energy.getMaxEnergy()}).withStyle(ChatFormatting.GRAY));
    }

    public boolean isBarVisible(ItemStack stack) {
        return this.getEnergy(stack).getEnergy() > 0;
    }

    public int getBarWidth(ItemStack stack) {
        UniversalEnergyStorage storage = this.getEnergy(stack);
        return Mth.clamp((int)((storage.getEnergy() + 1) * 13 / storage.getMaxEnergy()), (int)0, (int)13);
    }

    public int getBarColor(ItemStack stack) {
        return 5294200;
    }

    @Nullable
    public UniversalEnergyStorage getEnergy(@NotNull ItemStack stack) {
        return new ItemEnergyStorage(stack, (DataComponentType)DataComponentsRegistry.ENERGY.get(), 3000);
    }
}

