/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.menus;

import com.st0x0ef.stellaris.common.blocks.entities.machines.AntennaBlockEntity;
import com.st0x0ef.stellaris.common.menus.BaseContainer;
import com.st0x0ef.stellaris.common.registry.MenuTypesRegistry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;

public class AntennaMenu
extends BaseContainer {
    private final Player player;
    private final AntennaBlockEntity blockEntity;
    public int launchPadId;

    public static AntennaMenu create(int containerId, Inventory inventory, FriendlyByteBuf buf) {
        AntennaBlockEntity blockEntity = (AntennaBlockEntity)inventory.player.level().getBlockEntity(buf.readBlockPos());
        return new AntennaMenu(containerId, inventory, blockEntity, buf.readInt());
    }

    public AntennaMenu(int containerId, Inventory inventory, AntennaBlockEntity blockEntity, int launchPadId) {
        super((MenuType)MenuTypesRegistry.ANTENNA_MENU.get(), containerId, 0, inventory, 10, 106);
        this.player = inventory.player;
        this.blockEntity = blockEntity;
        this.launchPadId = launchPadId;
    }

    @Override
    public ItemStack quickMoveStack(Player player, int invSlot) {
        return ItemStack.EMPTY;
    }

    @Override
    public boolean stillValid(Player player) {
        return !player.level().isClientSide();
    }

    public Player getPlayer() {
        return this.player;
    }

    public AntennaBlockEntity getBlockEntity() {
        return this.blockEntity;
    }
}

