/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.registries.RegisterEvent;
import noppes.npcs.CustomNpcs;
import noppes.npcs.entity.EntityChairMount;
import noppes.npcs.entity.EntityCustomNpc;
import noppes.npcs.entity.EntityNPC64x32;
import noppes.npcs.entity.EntityNPCGolem;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.entity.EntityNpcAlex;
import noppes.npcs.entity.EntityNpcClassicPlayer;
import noppes.npcs.entity.EntityNpcCrystal;
import noppes.npcs.entity.EntityNpcDragon;
import noppes.npcs.entity.EntityNpcPony;
import noppes.npcs.entity.EntityNpcSlime;
import noppes.npcs.entity.EntityProjectile;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD, modid="customnpcs")
public class CustomEntities {
    public static EntityType<? extends EntityNPCInterface> entityNpcPony;
    public static EntityType<? extends EntityNPCInterface> entityNpcCrystal;
    public static EntityType<? extends EntityNPCInterface> entityNpcSlime;
    public static EntityType<? extends EntityNPCInterface> entityNpcDragon;
    public static EntityType<? extends EntityNPCInterface> entityNPCGolem;
    public static EntityType<? extends EntityNPCInterface> entityCustomNpc;
    public static EntityType<? extends EntityNPCInterface> entityNPC64x32;
    public static EntityType<? extends EntityNPCInterface> entityNpcAlex;
    public static EntityType<? extends EntityNPCInterface> entityNpcClassicPlayer;
    public static EntityType<?> entityChairMount;
    public static EntityType<? extends ThrowableProjectile> entityProjectile;
    private static List<EntityType<?>> types;

    @SubscribeEvent
    public static void registerEntities(RegisterEvent event) {
        if (event.getRegistry() == BuiltInRegistries.ENTITY_TYPE) {
            types.clear();
            entityNpcPony = CustomEntities.registerNpc(EntityNpcPony.class, "npcpony", EntityNpcPony::new);
            entityNpcCrystal = CustomEntities.registerNpc(EntityNpcCrystal.class, "npccrystal", EntityNpcCrystal::new);
            entityNpcSlime = CustomEntities.registerNpc(EntityNpcSlime.class, "npcslime", EntityNpcSlime::new);
            entityNpcDragon = CustomEntities.registerNpc(EntityNpcDragon.class, "npcdragon", EntityNpcDragon::new);
            entityNPCGolem = CustomEntities.registerNpc(EntityNPCGolem.class, "npcgolem", EntityNPCGolem::new);
            entityCustomNpc = CustomEntities.registerNpc(EntityCustomNpc.class, "customnpc", EntityCustomNpc::new);
            entityNPC64x32 = CustomEntities.registerNpc(EntityNPC64x32.class, "customnpc64x32", EntityNPC64x32::new);
            entityNpcAlex = CustomEntities.registerNpc(EntityNpcAlex.class, "customnpcalex", EntityNpcAlex::new);
            entityNpcClassicPlayer = CustomEntities.registerNpc(EntityNpcClassicPlayer.class, "customnpcclassic", EntityNpcClassicPlayer::new);
            entityChairMount = CustomEntities.registerNewentity(EntityChairMount.class, "customnpcchairmount", EntityChairMount::new, 64, 10, false, 0.001f, 0.001f);
            entityProjectile = CustomEntities.registerNewentity(EntityProjectile.class, "customnpcprojectile", EntityProjectile::new, 64, 20, true, 0.5f, 0.5f);
        }
    }

    @SubscribeEvent
    public static void attribute(EntityAttributeCreationEvent event) {
        for (EntityType<?> type : types) {
            event.put(type, EntityNPCInterface.createMobAttributes().build());
        }
    }

    private static <T extends Entity> EntityType<T> registerNpc(Class<? extends Entity> c, String name, EntityType.EntityFactory<T> factoryIn) {
        EntityType.Builder builder = EntityType.Builder.of(factoryIn, (MobCategory)MobCategory.CREATURE);
        builder.updateInterval(3);
        builder.clientTrackingRange(10);
        builder.sized(1.0f, 1.0f);
        ResourceLocation registryName = new ResourceLocation("customnpcs", name);
        EntityType type = builder.build(registryName.toString());
        types.add(type);
        Registry.register((Registry)BuiltInRegistries.ENTITY_TYPE, (ResourceLocation)registryName, (Object)type);
        if (CustomNpcs.FixUpdateFromPre_1_12) {
            registryName = ResourceLocation.tryParse((String)("customnpcs." + name));
            Registry.register((Registry)BuiltInRegistries.ENTITY_TYPE, (ResourceLocation)registryName, (Object)builder.build(registryName.toString()));
        }
        return type;
    }

    private static <T extends Entity> EntityType<T> registerNewentity(Class<? extends Entity> c, String name, EntityType.EntityFactory<T> factoryIn, int range, int update, boolean velocity, float width, float height) {
        EntityType.Builder builder = EntityType.Builder.of(factoryIn, (MobCategory)MobCategory.MISC);
        builder.updateInterval(update);
        builder.sized(width, height);
        builder.clientTrackingRange(4);
        ResourceLocation registryName = new ResourceLocation("customnpcs", name);
        EntityType type = builder.build(registryName.toString());
        Registry.register((Registry)BuiltInRegistries.ENTITY_TYPE, (ResourceLocation)registryName, (Object)type);
        return type;
    }

    static {
        types = new ArrayList();
    }
}

