/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs;

import java.util.Locale;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import noppes.npcs.ModelDataShared;
import noppes.npcs.controllers.CobblemonHelper;
import noppes.npcs.controllers.PixelmonHelper;
import noppes.npcs.entity.EntityCustomNpc;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.shared.common.util.LogWriter;

public class ModelData
extends ModelDataShared {
    public boolean simpleRender = false;
    public EntityCustomNpc npc;

    public ModelData(EntityCustomNpc npc) {
        this.npc = npc;
    }

    public LivingEntity getEntity(EntityNPCInterface npc) {
        if (!this.hasEntity()) {
            return null;
        }
        if (this.entity == null) {
            try {
                this.entity = (LivingEntity)((EntityType)BuiltInRegistries.ENTITY_TYPE.get(this.getEntityName())).create(npc.level());
                CompoundTag comp = new CompoundTag();
                this.entity.addAdditionalSaveData(comp);
                if (PixelmonHelper.isPixelmon((Entity)this.entity) && !this.extra.contains("Name")) {
                    this.extra.putString("Name", "abra");
                }
                comp = comp.merge(this.extra);
                try {
                    this.entity.readAdditionalSaveData(comp);
                    if (PixelmonHelper.isPixelmon((Entity)this.entity)) {
                        PixelmonHelper.initEntity(this.entity, this.extra.getString("Name"));
                    }
                    if (CobblemonHelper.isPokemon((Entity)this.entity)) {
                        CobblemonHelper.setType((Entity)this.entity, ResourceLocation.tryParse((String)this.extra.getString("CobblemonModel")));
                    }
                }
                catch (Exception e) {
                    LogWriter.except(e);
                }
                this.entity.setInvulnerable(true);
                this.entity.getAttribute(Attributes.MAX_HEALTH).setBaseValue((double)npc.getMaxHealth());
                for (EquipmentSlot slot : EquipmentSlot.values()) {
                    this.entity.setItemSlot(slot, npc.getItemBySlot(slot));
                }
            }
            catch (Exception e) {
                LogWriter.except(e);
            }
        }
        return this.entity;
    }

    public ModelData copy() {
        ModelData data = new ModelData(this.npc);
        data.load(this.save());
        return data;
    }

    @Override
    public CompoundTag save() {
        CompoundTag compound = super.save();
        compound.putBoolean("SimpleRender", this.simpleRender);
        return compound;
    }

    @Override
    public void load(CompoundTag compound) {
        super.load(compound);
        this.simpleRender = compound.getBoolean("SimpleRender");
    }

    public void setExtra(LivingEntity entity, String key, String value) {
        if ((key = key.toLowerCase(Locale.ROOT)).equalsIgnoreCase("name") && PixelmonHelper.isPixelmon((Entity)entity)) {
            this.extra.putString("Name", value);
        }
        if (key.equalsIgnoreCase("cobblemonmodel") && CobblemonHelper.isPokemon((Entity)entity)) {
            this.extra.putString("CobblemonModel", value);
        }
        this.clearEntity();
    }

    @Override
    public LivingEntity getOwner() {
        return this.npc;
    }

    public static ModelData get(EntityCustomNpc npc) {
        return npc.modelData;
    }
}

