/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs;

import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetObjectivePacket;
import net.minecraft.network.protocol.game.ClientboundSetScorePacket;
import net.minecraft.server.ServerScoreboard;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.ReadOnlyScoreInfo;
import net.minecraft.world.scores.ScoreAccess;
import net.minecraft.world.scores.ScoreHolder;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import noppes.npcs.CustomItems;
import noppes.npcs.NBTTags;
import noppes.npcs.controllers.MassBlockController;
import noppes.npcs.controllers.SchematicController;
import noppes.npcs.controllers.SyncController;
import noppes.npcs.controllers.VisibilityController;
import noppes.npcs.controllers.data.Availability;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.controllers.data.PlayerQuestData;
import noppes.npcs.entity.data.DataScenes;
import noppes.npcs.packets.Packets;
import noppes.npcs.packets.client.PacketSync;

public class ServerTickHandler {
    public int ticks = 0;

    @SubscribeEvent
    public void onServerTick(PlayerTickEvent.Pre event) {
        if (event.getEntity().getServer() != null) {
            NBTTags.server = event.getEntity().getServer();
        }
        if (event.getEntity().level().isClientSide()) {
            return;
        }
        Player player = event.getEntity();
        PlayerData data = PlayerData.get(player);
        if (player.getCommandSenderWorld().getDayTime() % 24000L == 1L || player.getCommandSenderWorld().getDayTime() % 240000L == 12001L) {
            VisibilityController.instance.onUpdate((ServerPlayer)player);
        }
        if (data.updateClient) {
            Packets.send((ServerPlayer)player, new PacketSync(8, data.getSyncNBT(), true));
            VisibilityController.instance.onUpdate((ServerPlayer)player);
            data.updateClient = false;
        }
        if (data.prevHeldItem != player.getMainHandItem() && (data.prevHeldItem.getItem() == CustomItems.wand || player.getMainHandItem().getItem() == CustomItems.wand)) {
            VisibilityController.instance.onUpdate((ServerPlayer)player);
        }
        data.prevHeldItem = player.getMainHandItem();
    }

    @SubscribeEvent
    public void onServerTick(LevelTickEvent.Pre event) {
        if (event.getLevel().isClientSide()) {
            return;
        }
    }

    @SubscribeEvent
    public void onServerTick(ServerTickEvent.Pre event) {
        if (this.ticks++ >= 20) {
            SchematicController.Instance.updateBuilding(event.getServer());
            MassBlockController.Update();
            this.ticks = 0;
            for (DataScenes.SceneState state : DataScenes.StartedScenes.values()) {
                if (state.paused) continue;
                ++state.ticks;
            }
            for (DataScenes.SceneContainer entry : DataScenes.ScenesToRun) {
                entry.update();
            }
            DataScenes.ScenesToRun = new ArrayList<DataScenes.SceneContainer>();
        }
    }

    @SubscribeEvent
    public void playerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.getEntity().level().isClientSide()) {
            return;
        }
        final ServerPlayer player = (ServerPlayer)event.getEntity();
        for (ServerLevel level : player.server.getAllLevels()) {
            ServerScoreboard board = level.getScoreboard();
            for (String objective : Availability.scores) {
                Objective so = board.getObjective(objective);
                if (so == null) continue;
                if (board.getObjectiveDisplaySlotCount(so) == 0) {
                    player.connection.send((Packet)new ClientboundSetObjectivePacket(so, 0));
                }
                ScoreAccess sco = board.getOrCreatePlayerScore((ScoreHolder)player, so);
                ReadOnlyScoreInfo info = board.getPlayerScoreInfo((ScoreHolder)player, so);
                player.connection.send((Packet)new ClientboundSetScorePacket(player.getScoreboardName(), so.getName(), sco.get(), Optional.of(sco.display()), Optional.of(info.numberFormat())));
            }
        }
        player.inventoryMenu.addSlotListener(new ContainerListener(){

            public void slotChanged(AbstractContainerMenu container, int slotInd, ItemStack stack) {
                if (player.level().isClientSide) {
                    return;
                }
                PlayerQuestData playerdata = PlayerData.get((Player)player).questData;
                playerdata.checkQuestCompletion((Player)player, 0);
            }

            public void dataChanged(AbstractContainerMenu container, int varToUpdate, int newValue) {
            }
        });
        PlayerData data = PlayerData.get((Player)player);
        String serverName = "local";
        if (player.server.isDedicatedServer()) {
            serverName = "server";
        } else if (player.server.isPublished()) {
            serverName = "lan";
        }
        SyncController.syncPlayer(player);
    }
}

