/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.ai;

import java.util.EnumSet;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.phys.Vec3;

public class EntityAIPanic
extends Goal {
    private PathfinderMob entityCreature;
    private float speed;
    private double randPosX;
    private double randPosY;
    private double randPosZ;

    public EntityAIPanic(PathfinderMob par1Mob, float limbSwingAmount) {
        this.entityCreature = par1Mob;
        this.speed = limbSwingAmount;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean canUse() {
        if (this.entityCreature.getTarget() == null && !this.entityCreature.isOnFire()) {
            return false;
        }
        Vec3 var1 = DefaultRandomPos.getPos((PathfinderMob)this.entityCreature, (int)5, (int)4);
        if (var1 == null) {
            return false;
        }
        this.randPosX = var1.x;
        this.randPosY = var1.y;
        this.randPosZ = var1.z;
        return true;
    }

    public void start() {
        this.entityCreature.getNavigation().moveTo(this.randPosX, this.randPosY, this.randPosZ, (double)this.speed);
    }

    public boolean canContinueToUse() {
        if (this.entityCreature.getTarget() == null) {
            return false;
        }
        return !this.entityCreature.getNavigation().isDone();
    }
}

