/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.ai;

import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.phys.Vec3;
import noppes.npcs.CustomNpcs;
import noppes.npcs.ai.selector.NPCInteractSelector;
import noppes.npcs.controllers.data.Line;
import noppes.npcs.entity.EntityNPCInterface;

public class EntityAIWander
extends Goal {
    private EntityNPCInterface entity;
    public final NPCInteractSelector selector;
    private double x;
    private double y;
    private double zPosition;
    private EntityNPCInterface nearbyNPC;

    public EntityAIWander(EntityNPCInterface npc) {
        this.entity = npc;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        this.selector = new NPCInteractSelector(npc);
    }

    public boolean canUse() {
        if (this.entity.getNoActionTime() >= 100 || !this.entity.getNavigation().isDone() || this.entity.isInteracting() || this.entity.isPassenger() || this.entity.ais.movingPause && this.entity.getRandom().nextInt(80) != 0) {
            return false;
        }
        if (this.entity.ais.npcInteracting && this.entity.getRandom().nextInt(this.entity.ais.movingPause ? 6 : 16) == 1) {
            this.nearbyNPC = this.getNearbyNPC();
        }
        if (this.nearbyNPC != null) {
            this.x = Mth.floor((double)this.nearbyNPC.getX());
            this.y = Mth.floor((double)this.nearbyNPC.getY());
            this.zPosition = Mth.floor((double)this.nearbyNPC.getZ());
            this.nearbyNPC.addInteract((LivingEntity)this.entity);
        } else {
            Vec3 vec = this.getVec();
            if (vec == null) {
                return false;
            }
            this.x = vec.x;
            this.y = vec.y;
            if (this.entity.ais.movementType == 1) {
                this.y = this.entity.getStartYPos() + (double)this.entity.getRandom().nextFloat() * 0.75 * (double)this.entity.ais.walkingRange;
            }
            this.zPosition = vec.z;
        }
        return true;
    }

    public void tick() {
        if (this.nearbyNPC != null) {
            this.nearbyNPC.getNavigation().stop();
        }
    }

    private EntityNPCInterface getNearbyNPC() {
        List list = this.entity.level().getEntities((Entity)this.entity, this.entity.getBoundingBox().inflate((double)this.entity.ais.walkingRange, this.entity.ais.walkingRange > 7 ? 7.0 : (double)this.entity.ais.walkingRange, (double)this.entity.ais.walkingRange), (Predicate)((Object)this.selector));
        Iterator ita = list.iterator();
        while (ita.hasNext()) {
            EntityNPCInterface npc = (EntityNPCInterface)((Object)ita.next());
            if (npc.ais.stopAndInteract && !npc.isAttacking() && npc.isAlive() && !this.entity.faction.isAggressiveToNpc(npc)) continue;
            ita.remove();
        }
        if (list.isEmpty()) {
            return null;
        }
        return (EntityNPCInterface)((Object)list.get(this.entity.getRandom().nextInt(list.size())));
    }

    private Vec3 getVec() {
        if (this.entity.ais.walkingRange > 0) {
            BlockPos start = new BlockPos((int)this.entity.getStartXPos(), (int)this.entity.getStartYPos(), (int)this.entity.getStartZPos());
            int distance = (int)Math.sqrt(this.entity.blockPosition().distSqr((Vec3i)start));
            int range = Math.min(this.entity.ais.walkingRange, CustomNpcs.NpcNavRange);
            if (range - distance < 4) {
                Vec3 pos2 = new Vec3((this.entity.getX() + (double)start.getX()) / 2.0, (this.entity.getY() + (double)start.getY()) / 2.0, (this.entity.getZ() + (double)start.getZ()) / 2.0);
                return DefaultRandomPos.getPosTowards((PathfinderMob)this.entity, (int)(range / 2), (int)Math.min(range / 2, 7), (Vec3)pos2, (double)1.5707963267948966);
            }
            return DefaultRandomPos.getPos((PathfinderMob)this.entity, (int)(range / 2), (int)Math.min(range / 2, 7));
        }
        return DefaultRandomPos.getPos((PathfinderMob)this.entity, (int)CustomNpcs.NpcNavRange, (int)7);
    }

    public boolean canContinueToUse() {
        if (this.nearbyNPC != null && (!this.selector.apply((Object)this.nearbyNPC) || this.entity.isInRange((Entity)this.nearbyNPC, this.entity.getBbWidth()))) {
            return false;
        }
        return !this.entity.getNavigation().isDone() && this.entity.isAlive() && !this.entity.isInteracting();
    }

    public void start() {
        this.entity.getNavigation().moveTo(this.entity.getNavigation().createPath(this.x, this.y, this.zPosition, 0), 1.0);
    }

    public void stop() {
        if (this.nearbyNPC != null && this.entity.isInRange((Entity)this.nearbyNPC, 3.5)) {
            Line line;
            EntityNPCInterface talk = this.entity;
            if (this.entity.getRandom().nextBoolean()) {
                talk = this.nearbyNPC;
            }
            if ((line = talk.advanced.getNPCInteractLine()) == null) {
                line = new Line(".........");
            }
            line.setShowText(false);
            talk.saySurrounding(line);
            this.entity.addInteract((LivingEntity)this.nearbyNPC);
            this.nearbyNPC.addInteract((LivingEntity)this.entity);
        }
        this.nearbyNPC = null;
    }
}

