/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.api.wrapper;

import java.util.UUID;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.entity.IEntityItem;
import noppes.npcs.api.item.IItemStack;
import noppes.npcs.api.wrapper.EntityWrapper;
import noppes.npcs.mixin.ItemEntityMixin;

public class EntityItemWrapper<T extends ItemEntity>
extends EntityWrapper<T>
implements IEntityItem {
    public EntityItemWrapper(T entity) {
        super(entity);
    }

    @Override
    public String getOwner() {
        if (((ItemEntity)this.entity).getOwner() == null) {
            return null;
        }
        return ((ItemEntity)this.entity).getOwner().toString();
    }

    @Override
    public void setOwner(String name) {
        ServerLevel serverlevel;
        Entity entity1;
        Level level = ((ItemEntity)this.entity).level();
        if (level instanceof ServerLevel && (entity1 = (serverlevel = (ServerLevel)level).getEntity(UUID.fromString(name))) != null) {
            ((ItemEntity)this.entity).setThrower(entity1);
        }
    }

    @Override
    public int getPickupDelay() {
        return ((ItemEntityMixin)this.entity).pickupDelay();
    }

    @Override
    public void setPickupDelay(int delay) {
        ((ItemEntity)this.entity).setPickUpDelay(delay);
    }

    @Override
    public int getType() {
        return 6;
    }

    @Override
    public long getAge() {
        return ((ItemEntity)this.entity).getAge();
    }

    @Override
    public void setAge(long age) {
        age = Math.max(Math.min(age, Integer.MAX_VALUE), Integer.MIN_VALUE);
        ((ItemEntityMixin)this.entity).age((int)age);
    }

    @Override
    public IItemStack getItem() {
        return NpcAPI.Instance().getIItemStack(((ItemEntity)this.entity).getItem());
    }

    @Override
    public void setItem(IItemStack item) {
        ItemStack stack = item == null ? ItemStack.EMPTY : item.getMCItemStack();
        ((ItemEntity)this.entity).setItem(stack);
    }
}

