/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.api.wrapper;

import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import noppes.npcs.api.item.IItemBook;
import noppes.npcs.api.wrapper.ItemStackWrapper;

public class ItemBookWrapper
extends ItemStackWrapper
implements IItemBook {
    protected ItemBookWrapper(ItemStack item) {
        super(item);
    }

    @Override
    public String getTitle() {
        return this.getTag().getString("title");
    }

    @Override
    public void setTitle(String title) {
        this.getTag().putString("title", title);
    }

    @Override
    public String getAuthor() {
        return this.getTag().getString("author");
    }

    @Override
    public void setAuthor(String author) {
        this.getTag().putString("author", author);
    }

    @Override
    public String[] getText() {
        ArrayList<String> list = new ArrayList<String>();
        ListTag pages = this.getTag().getList("pages", 8);
        for (int i = 0; i < pages.size(); ++i) {
            list.add(pages.getString(i));
        }
        return list.toArray(new String[list.size()]);
    }

    @Override
    public void setText(String[] pages) {
        ListTag list = new ListTag();
        if (pages != null && pages.length > 0) {
            for (String page : pages) {
                list.add((Object)StringTag.valueOf((String)page));
            }
        }
        this.getTag().put("pages", (Tag)list);
    }

    private CompoundTag getTag() {
        if (this.item.getComponents() == DataComponentMap.EMPTY) {
            return new CompoundTag();
        }
        PatchedDataComponentMap data = (PatchedDataComponentMap)this.item.getComponents();
        return (CompoundTag)DataComponentPatch.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)data.asPatch()).getOrThrow();
    }

    @Override
    public boolean isBook() {
        return true;
    }

    @Override
    public int getType() {
        return 1;
    }
}

