/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.api.wrapper;

import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import noppes.npcs.NBTTags;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.item.IItemStack;
import noppes.npcs.api.overlay.IRenderItemOverlay;
import noppes.npcs.api.wrapper.OverlayComponentWrapper;

public class OverlayRenderItemWrapper
extends OverlayComponentWrapper
implements IRenderItemOverlay {
    private ItemStack item;

    public OverlayRenderItemWrapper(int id, int x, int y, IItemStack item) {
        super(id, x, y);
        this.item = item == null ? ItemStack.EMPTY : item.getMCItemStack();
    }

    @Override
    public IItemStack getItem() {
        return NpcAPI.Instance().getIItemStack(this.item);
    }

    @Override
    public IRenderItemOverlay setItem(IItemStack item) {
        this.item = item.getMCItemStack();
        return this;
    }

    @Override
    public int getType() {
        return 2;
    }

    @Override
    public void toNbt(CompoundTag compound) {
        super.toNbt(compound);
        CompoundTag tag = new CompoundTag();
        if (!this.item.isEmpty()) {
            tag = (CompoundTag)this.item.save(NBTTags.getProvider(), (Tag)tag);
        }
        compound.put("item", (Tag)tag);
    }

    @Override
    public void fromNbt(CompoundTag compound) {
        super.fromNbt(compound);
        this.item = ItemStack.parseOptional((HolderLookup.Provider)NBTTags.getProvider(), (CompoundTag)compound.getCompound("item"));
    }
}

