/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.custom.components;

import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import noppes.npcs.api.gui.ICustomGuiComponent;
import noppes.npcs.api.wrapper.gui.CustomGuiColoredLineWrapper;
import noppes.npcs.client.gui.custom.GuiCustom;
import noppes.npcs.client.gui.custom.interfaces.IGuiComponent;

public class CustomGuiColoredLine
extends AbstractWidget
implements IGuiComponent {
    private GuiCustom parent;
    public CustomGuiColoredLineWrapper component;
    public int id;

    public CustomGuiColoredLine(GuiCustom parent, CustomGuiColoredLineWrapper component) {
        super(component.getPosX(), component.getPosY(), component.getXEnd() - component.getPosX(), component.getYEnd() - component.getPosY(), (Component)Component.empty());
        this.component = component;
        this.parent = parent;
        this.init();
    }

    @Override
    public void init() {
        this.id = this.component.getID();
        this.setX(this.component.getPosX());
        this.setY(this.component.getPosY());
        this.setWidth(this.component.getXEnd() - this.component.getPosX());
        this.height = this.component.getYEnd() - this.component.getPosY();
        this.active = true;
        this.visible = true;
    }

    @Override
    public int getID() {
        return this.id;
    }

    @Override
    public void onRender(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.visible) {
            int color = this.component.getColor();
            int r = color >> 24 & 0xFF;
            int g = color >> 16 & 0xFF;
            int b = color >> 8 & 0xFF;
            int a = color & 0xFF;
            double dx = this.component.getXEnd() - this.getX();
            double dy = this.component.getYEnd() - this.getY();
            double length = Math.sqrt(dx * dx + dy * dy);
            double nx = -dy / length * (double)this.component.getThickness() / 2.0;
            double ny = dx / length * (double)this.component.getThickness() / 2.0;
            VertexConsumer builder = graphics.bufferSource().getBuffer(RenderType.gui());
            builder.addVertex((float)((double)this.component.getXEnd() + nx), (float)((double)this.component.getYEnd() + ny), (float)this.id).setColor(r, g, b, a);
            builder.addVertex((float)((double)this.component.getXEnd() - nx), (float)((double)this.component.getYEnd() - ny), (float)this.id).setColor(r, g, b, a);
            builder.addVertex((float)((double)this.getX() - nx), (float)((double)this.getY() - ny), (float)this.id).setColor(r, g, b, a);
            builder.addVertex((float)((double)this.getX() + nx), (float)((double)this.getY() + ny), (float)this.id).setColor(r, g, b, a);
            graphics.flush();
        }
    }

    protected int getYImage(boolean p_getYImage_1_) {
        return 0;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int mouseButton, double dx, double dy) {
        return true;
    }

    public static CustomGuiColoredLine fromComponent(GuiCustom parent, CustomGuiColoredLineWrapper component) {
        CustomGuiColoredLine line = new CustomGuiColoredLine(parent, component);
        return line;
    }

    @Override
    public ICustomGuiComponent component() {
        return this.component;
    }

    protected void renderWidget(GuiGraphics p_282139_, int p_268034_, int p_268009_, float p_268085_) {
    }

    public void updateWidgetNarration(NarrationElementOutput p_169152_) {
    }
}

