/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.renderer.blocks;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import noppes.npcs.CustomBlocks;
import noppes.npcs.CustomItems;
import noppes.npcs.blocks.tiles.TileDoor;
import noppes.npcs.client.renderer.blocks.BlockRendererInterface;

public class BlockDoorRenderer
extends BlockRendererInterface<TileDoor> {
    private static Random random = new Random();

    public BlockDoorRenderer(BlockEntityRendererProvider.Context dispatcher) {
        super(dispatcher);
    }

    public void render(TileDoor tile, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int light, int overlay) {
        BlockState original = tile.getLevel().getBlockState(tile.getBlockPos());
        if (original.isAir()) {
            return;
        }
        BlockPos lowerPos = tile.getBlockPos();
        if (original.getValue((Property)DoorBlock.HALF) == DoubleBlockHalf.UPPER) {
            lowerPos = tile.getBlockPos().below();
        }
        BlockPos upperPos = lowerPos.above();
        TileDoor lowerTile = (TileDoor)tile.getLevel().getBlockEntity(lowerPos);
        TileDoor upperTile = (TileDoor)tile.getLevel().getBlockEntity(upperPos);
        if (lowerTile == null || upperTile == null) {
            return;
        }
        BlockState lowerState = lowerTile.getBlockState();
        BlockState upperState = upperTile.getBlockState();
        Block b = lowerTile.blockModel;
        if (this.overrideModel()) {
            b = CustomBlocks.scripted_door;
        }
        BlockState state = b.defaultBlockState();
        state = (BlockState)state.setValue((Property)DoorBlock.HALF, (Comparable)((DoubleBlockHalf)original.getValue((Property)DoorBlock.HALF)));
        state = (BlockState)state.setValue((Property)DoorBlock.FACING, (Comparable)((Direction)lowerState.getValue((Property)DoorBlock.FACING)));
        state = (BlockState)state.setValue((Property)DoorBlock.OPEN, (Comparable)((Boolean)lowerState.getValue((Property)DoorBlock.OPEN)));
        state = (BlockState)state.setValue((Property)DoorBlock.HINGE, (Comparable)((DoorHingeSide)upperState.getValue((Property)DoorBlock.HINGE)));
        state = (BlockState)state.setValue((Property)DoorBlock.POWERED, (Comparable)((Boolean)upperState.getValue((Property)DoorBlock.POWERED)));
        matrixStack.pushPose();
        this.renderBlock(matrixStack, buffer, tile, lowerState.getBlock(), state, light, overlay);
        matrixStack.popPose();
    }

    private void renderBlock(PoseStack matrixStack, MultiBufferSource buffer, TileDoor tile, Block b, BlockState state, int light, int overlay) {
        BlockRenderDispatcher dispatcher = Minecraft.getInstance().getBlockRenderer();
        BakedModel ibakedmodel = dispatcher.getBlockModel(state);
        if (ibakedmodel == null) {
            dispatcher.renderSingleBlock(state, matrixStack, buffer, light, overlay);
        } else {
            dispatcher.getModelRenderer().renderModel(matrixStack.last(), buffer.getBuffer(ItemBlockRenderTypes.getRenderType((BlockState)state, (boolean)false)), state, ibakedmodel, 1.0f, 1.0f, 1.0f, light, overlay);
        }
    }

    private boolean overrideModel() {
        ItemStack held = Minecraft.getInstance().player.getMainHandItem();
        if (held == null) {
            return false;
        }
        return held.getItem() == CustomItems.wand || held.getItem() == CustomItems.scripter || held.getItem() == CustomBlocks.scripted_door_item;
    }
}

