/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.command;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.client.EntityUtil;
import noppes.npcs.controllers.DialogController;
import noppes.npcs.controllers.SyncController;
import noppes.npcs.controllers.data.Dialog;
import noppes.npcs.controllers.data.DialogOption;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.entity.EntityDialogNpc;

public class CmdDialog {
    public static LiteralArgumentBuilder<CommandSourceStack> register() {
        LiteralArgumentBuilder command = Commands.literal((String)"dialog");
        command.then(((LiteralArgumentBuilder)Commands.literal((String)"reload").requires(source -> source.hasPermission(4))).executes(context -> {
            new DialogController().load((HolderLookup.Provider)((CommandSourceStack)context.getSource()).registryAccess());
            SyncController.syncAllDialogs((HolderLookup.Provider)((CommandSourceStack)context.getSource()).registryAccess());
            return 1;
        }));
        command.then(((LiteralArgumentBuilder)Commands.literal((String)"read").requires(source -> source.hasPermission(2))).then(Commands.argument((String)"players", (ArgumentType)EntityArgument.players()).then(Commands.argument((String)"dialog", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> {
            Collection players = EntityArgument.getPlayers((CommandContext)context, (String)"players");
            if (players.isEmpty()) {
                return 1;
            }
            Dialog dialog = DialogController.instance.dialogs.get(IntegerArgumentType.getInteger((CommandContext)context, (String)"dialog"));
            if (dialog == null) {
                throw new SimpleCommandExceptionType((Message)Component.literal((String)"Unknown DialogID")).create();
            }
            for (ServerPlayer player : players) {
                PlayerData data = PlayerData.get((Player)player);
                if (data.dialogData.dialogsRead.contains(dialog.id)) continue;
                data.dialogData.dialogsRead.add(dialog.id);
                data.save(true);
            }
            return 1;
        }))));
        command.then(((LiteralArgumentBuilder)Commands.literal((String)"unread").requires(source -> source.hasPermission(2))).then(Commands.argument((String)"players", (ArgumentType)EntityArgument.players()).then(Commands.argument((String)"dialog", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> {
            Collection players = EntityArgument.getPlayers((CommandContext)context, (String)"players");
            if (players.isEmpty()) {
                return 1;
            }
            Dialog dialog = DialogController.instance.dialogs.get(IntegerArgumentType.getInteger((CommandContext)context, (String)"dialog"));
            if (dialog == null) {
                throw new SimpleCommandExceptionType((Message)Component.literal((String)"Unknown DialogID")).create();
            }
            for (ServerPlayer player : players) {
                PlayerData data = PlayerData.get((Player)player);
                if (!data.dialogData.dialogsRead.contains(dialog.id)) continue;
                data.dialogData.dialogsRead.remove(dialog.id);
                data.save(true);
            }
            return 1;
        }))));
        command.then(((LiteralArgumentBuilder)Commands.literal((String)"show").requires(source -> source.hasPermission(2))).then(Commands.argument((String)"players", (ArgumentType)EntityArgument.players()).then(Commands.argument((String)"dialog", (ArgumentType)IntegerArgumentType.integer((int)0)).then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.string()).executes(context -> {
            Collection players = EntityArgument.getPlayers((CommandContext)context, (String)"players");
            if (players.isEmpty()) {
                return 1;
            }
            Dialog dialog = DialogController.instance.dialogs.get(IntegerArgumentType.getInteger((CommandContext)context, (String)"dialog"));
            if (dialog == null) {
                throw new SimpleCommandExceptionType((Message)Component.literal((String)"Unknown DialogID")).create();
            }
            EntityDialogNpc npc = new EntityDialogNpc((Level)((CommandSourceStack)context.getSource()).getLevel());
            DialogOption option = new DialogOption();
            option.dialogId = dialog.id;
            option.title = dialog.title;
            npc.dialogs.put(0, option);
            npc.display.setName(StringArgumentType.getString((CommandContext)context, (String)"name"));
            for (ServerPlayer player : players) {
                EntityUtil.Copy((LivingEntity)player, (LivingEntity)npc);
                NoppesUtilServer.openDialog((Player)player, npc, dialog);
            }
            return 1;
        })))));
        return command;
    }
}

