/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.containers;

import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import noppes.npcs.CustomBlocks;
import noppes.npcs.CustomContainer;
import noppes.npcs.containers.SlotNpcCrafting;
import noppes.npcs.controllers.RecipeController;
import noppes.npcs.controllers.data.RecipeCarpentry;

public class ContainerCarpentryBench
extends AbstractContainerMenu {
    public CraftingContainer craftMatrix = new TransientCraftingContainer((AbstractContainerMenu)this, 4, 4);
    public Container craftResult = new ResultContainer();
    private Player player;
    private BlockPos pos;

    public ContainerCarpentryBench(int id, Inventory par1PlayerInventory, BlockPos pos) {
        super(CustomContainer.container_carpentrybench, id);
        int var7;
        int var6;
        this.pos = pos;
        this.player = par1PlayerInventory.player;
        this.addSlot((Slot)new SlotNpcCrafting(par1PlayerInventory.player, this.craftMatrix, this.craftResult, 0, 133, 41));
        for (var6 = 0; var6 < 4; ++var6) {
            for (var7 = 0; var7 < 4; ++var7) {
                this.addSlot(new Slot((Container)this.craftMatrix, var7 + var6 * 4, 17 + var7 * 18, 14 + var6 * 18));
            }
        }
        for (var6 = 0; var6 < 3; ++var6) {
            for (var7 = 0; var7 < 9; ++var7) {
                this.addSlot(new Slot((Container)par1PlayerInventory, var7 + var6 * 9 + 9, 8 + var7 * 18, 98 + var6 * 18));
            }
        }
        for (var6 = 0; var6 < 9; ++var6) {
            this.addSlot(new Slot((Container)par1PlayerInventory, var6, 8 + var6 * 18, 156));
        }
        this.slotsChanged((Container)this.craftMatrix);
    }

    public void slotsChanged(Container par1Container) {
        if (!this.player.level().isClientSide) {
            RecipeCarpentry recipe = RecipeController.instance.findMatchingRecipe(this.craftMatrix);
            ItemStack item = ItemStack.EMPTY;
            if (recipe != null && recipe.availability.isAvailable(this.player)) {
                item = recipe.assemble(this.craftMatrix.asCraftInput(), (HolderLookup.Provider)this.player.level().registryAccess());
            }
            this.craftResult.setItem(0, item);
            ServerPlayer plmp = (ServerPlayer)this.player;
            plmp.connection.send((Packet)new ClientboundContainerSetSlotPacket(this.containerId, this.incrementStateId(), 0, item));
        }
    }

    public void removed(Player par1Player) {
        super.removed(par1Player);
        if (!par1Player.level().isClientSide) {
            for (int var2 = 0; var2 < 16; ++var2) {
                ItemStack var3 = this.craftMatrix.removeItemNoUpdate(var2);
                if (var3 == null) continue;
                par1Player.drop(var3, false);
            }
        }
    }

    public boolean stillValid(Player par1Player) {
        return par1Player.level().getBlockState(this.pos).getBlock() == CustomBlocks.carpenty && par1Player.distanceToSqr((double)this.pos.getX() + 0.5, (double)this.pos.getY() + 0.5, (double)this.pos.getZ() + 0.5) <= 64.0;
    }

    public ItemStack quickMoveStack(Player par1Player, int par1) {
        ItemStack var2 = ItemStack.EMPTY;
        Slot var3 = (Slot)this.slots.get(par1);
        if (var3 != null && var3.hasItem()) {
            ItemStack var4 = var3.getItem();
            var2 = var4.copy();
            if (par1 == 0) {
                if (!this.moveItemStackTo(var4, 17, 53, true)) {
                    return ItemStack.EMPTY;
                }
                var3.onQuickCraft(var4, var2);
            } else if (par1 >= 17 && par1 < 44 ? !this.moveItemStackTo(var4, 44, 53, false) : (par1 >= 44 && par1 < 53 ? !this.moveItemStackTo(var4, 17, 44, false) : !this.moveItemStackTo(var4, 17, 53, false))) {
                return ItemStack.EMPTY;
            }
            if (var4.getCount() == 0) {
                var3.set(ItemStack.EMPTY);
            } else {
                var3.setChanged();
            }
            if (var4.getCount() == var2.getCount()) {
                return ItemStack.EMPTY;
            }
            var3.onTake(par1Player, var4);
        }
        return var2;
    }

    public boolean canTakeItemForPickAll(ItemStack stack, Slot slotIn) {
        return slotIn.container != this.craftResult && super.canTakeItemForPickAll(stack, slotIn);
    }
}

