/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.containers;

import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.containers.ContainerNPCTrader;

public class InventoryNpcTrader
implements Container {
    private String inventoryTitle;
    private int slotsCount;
    public final NonNullList<ItemStack> inventoryContents;
    private ContainerNPCTrader con;

    public InventoryNpcTrader(String s, int i, ContainerNPCTrader con) {
        this.con = con;
        this.inventoryTitle = s;
        this.slotsCount = i;
        this.inventoryContents = NonNullList.withSize((int)i, (Object)ItemStack.EMPTY);
    }

    public ItemStack getItem(int i) {
        ItemStack toBuy = (ItemStack)this.inventoryContents.get(i);
        if (NoppesUtilServer.IsItemStackNull(toBuy)) {
            return ItemStack.EMPTY;
        }
        return toBuy.copy();
    }

    public ItemStack removeItem(int i, int j) {
        ItemStack stack = (ItemStack)this.inventoryContents.get(i);
        if (!NoppesUtilServer.IsItemStackNull(stack)) {
            return stack.copy();
        }
        return ItemStack.EMPTY;
    }

    public void setItem(int i, ItemStack itemstack) {
        if (!itemstack.isEmpty()) {
            this.inventoryContents.set(i, (Object)itemstack.copy());
        }
        this.setChanged();
    }

    public int getContainerSize() {
        return this.slotsCount;
    }

    public int getMaxStackSize() {
        return 64;
    }

    public boolean stillValid(Player entityplayer) {
        return true;
    }

    public ItemStack removeItemNoUpdate(int i) {
        return (ItemStack)this.inventoryContents.set(i, (Object)ItemStack.EMPTY);
    }

    public boolean canPlaceItem(int i, ItemStack itemstack) {
        return true;
    }

    public void setChanged() {
        this.con.slotsChanged(this);
    }

    public void startOpen(Player player) {
    }

    public void stopOpen(Player player) {
    }

    public boolean isEmpty() {
        for (int slot = 0; slot < this.getContainerSize(); ++slot) {
            ItemStack item = this.getItem(slot);
            if (NoppesUtilServer.IsItemStackNull(item) || item.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public void clearContent() {
    }
}

