/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import noppes.npcs.CustomNpcs;
import noppes.npcs.EventHooks;
import noppes.npcs.api.handler.IRecipeHandler;
import noppes.npcs.api.handler.data.IRecipe;
import noppes.npcs.controllers.data.RecipeCarpentry;
import noppes.npcs.controllers.data.RecipesDefault;

public class RecipeController
implements IRecipeHandler {
    public HashMap<ResourceLocation, RecipeCarpentry> globalRecipes = new HashMap();
    public HashMap<ResourceLocation, RecipeCarpentry> anvilRecipes = new HashMap();
    public static RecipeController instance;
    public static final int version = 1;
    public int nextId = 1;
    public static HashMap<Integer, RecipeCarpentry> syncRecipes;

    public RecipeController() {
        instance = this;
    }

    public void load(HolderLookup.Provider provider) {
        this.loadCategories(provider);
        this.reloadGlobalRecipes();
        EventHooks.onGlobalRecipesLoaded(this);
    }

    public void reloadGlobalRecipes() {
    }

    private void loadCategories(HolderLookup.Provider provider) {
        File saveDir = CustomNpcs.getLevelSaveDirectory();
        try {
            File file = new File(saveDir, "recipes.dat");
            if (file.exists()) {
                this.loadCategories(provider, file);
            } else {
                this.globalRecipes.clear();
                this.anvilRecipes.clear();
                this.loadDefaultRecipes(provider, -1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                File file = new File(saveDir, "recipes.dat_old");
                if (file.exists()) {
                    this.loadCategories(provider, file);
                }
            }
            catch (Exception ee) {
                e.printStackTrace();
            }
        }
    }

    private void loadDefaultRecipes(HolderLookup.Provider provider, int i) {
        if (i == 1) {
            return;
        }
        RecipesDefault.loadDefaultRecipes(i);
        this.saveCategories(provider);
    }

    private void loadCategories(HolderLookup.Provider provider, File file) throws Exception {
    }

    private void saveCategories(HolderLookup.Provider provider) {
        try {
            File saveDir = CustomNpcs.getLevelSaveDirectory();
            ListTag list = new ListTag();
            for (RecipeCarpentry recipe : this.globalRecipes.values()) {
                if (!recipe.savesRecipe) continue;
                list.add((Object)recipe.writeNBT(provider));
            }
            for (RecipeCarpentry recipe : this.anvilRecipes.values()) {
                if (!recipe.savesRecipe) continue;
                list.add((Object)recipe.writeNBT(provider));
            }
            CompoundTag nbttagcompound = new CompoundTag();
            nbttagcompound.put("Data", (Tag)list);
            nbttagcompound.putInt("LastId", this.nextId);
            nbttagcompound.putInt("Version", 1);
            File file = new File(saveDir, "recipes.dat_new");
            File file1 = new File(saveDir, "recipes.dat_old");
            File file2 = new File(saveDir, "recipes.dat");
            NbtIo.writeCompressed((CompoundTag)nbttagcompound, (OutputStream)new FileOutputStream(file));
            if (file1.exists()) {
                file1.delete();
            }
            file2.renameTo(file1);
            if (file2.exists()) {
                file2.delete();
            }
            file.renameTo(file2);
            if (file.exists()) {
                file.delete();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public RecipeCarpentry findMatchingRecipe(CraftingContainer inventoryCrafting) {
        for (RecipeCarpentry recipe : this.anvilRecipes.values()) {
            if (!recipe.isValid() || !recipe.matches(inventoryCrafting.asCraftInput(), null)) continue;
            return recipe;
        }
        return null;
    }

    public RecipeCarpentry getRecipe(int id) {
        if (this.globalRecipes.containsKey(id)) {
            return this.globalRecipes.get(id);
        }
        if (this.anvilRecipes.containsKey(id)) {
            return this.anvilRecipes.get(id);
        }
        return null;
    }

    public RecipeCarpentry saveRecipe(RecipeCarpentry recipe) {
        return null;
    }

    private int getUniqueId() {
        ++this.nextId;
        return this.nextId;
    }

    private boolean containsRecipeName(String name) {
        return false;
    }

    @Override
    public RecipeCarpentry delete(int id) {
        RecipeCarpentry recipe = this.getRecipe(id);
        if (recipe == null) {
            return null;
        }
        return recipe;
    }

    @Override
    public List<IRecipe> getGlobalList() {
        return new ArrayList<IRecipe>(this.globalRecipes.values());
    }

    @Override
    public List<IRecipe> getCarpentryList() {
        return new ArrayList<IRecipe>(this.anvilRecipes.values());
    }

    @Override
    public IRecipe addRecipe(String name, boolean global, ItemStack result, Object ... objects) {
        return null;
    }

    @Override
    public IRecipe addRecipe(String name, boolean global, ItemStack result, int width, int height, ItemStack ... objects) {
        NonNullList list = NonNullList.create();
        for (ItemStack item : objects) {
            if (item.isEmpty()) continue;
            list.add((Object)Ingredient.of((ItemStack[])new ItemStack[]{item}));
        }
        return null;
    }

    static {
        syncRecipes = new HashMap();
    }
}

