/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers.data;

import java.util.HashMap;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import noppes.npcs.NBTTags;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.NpcMiscInventory;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.containers.ContainerNPCBankInterface;
import noppes.npcs.controllers.BankController;
import noppes.npcs.controllers.data.Bank;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.packets.Packets;
import noppes.npcs.packets.client.PacketGuiData;
import noppes.npcs.util.CustomNPCsScheduler;

public class BankData {
    public HashMap<Integer, NpcMiscInventory> itemSlots = new HashMap();
    public HashMap<Integer, Boolean> upgradedSlots = new HashMap();
    public int unlockedSlots = 0;
    public int bankId = -1;

    public BankData() {
        for (int i = 0; i < 6; ++i) {
            this.itemSlots.put(i, new NpcMiscInventory(54));
            this.upgradedSlots.put(i, false);
        }
    }

    public void readNBT(HolderLookup.Provider lookupProvider, CompoundTag nbttagcompound) {
        this.bankId = nbttagcompound.getInt("DataBankId");
        this.unlockedSlots = nbttagcompound.getInt("UnlockedSlots");
        this.itemSlots = this.getItemSlots(lookupProvider, nbttagcompound.getList("BankInv", 10));
        this.upgradedSlots = NBTTags.getBooleanList(nbttagcompound.getList("UpdatedSlots", 10));
    }

    private HashMap<Integer, NpcMiscInventory> getItemSlots(HolderLookup.Provider lookupProvider, ListTag tagList) {
        HashMap<Integer, NpcMiscInventory> list = new HashMap<Integer, NpcMiscInventory>();
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundTag nbttagcompound = tagList.getCompound(i);
            int slot = nbttagcompound.getInt("Slot");
            NpcMiscInventory inv = new NpcMiscInventory(54);
            inv.setFromNBT(lookupProvider, nbttagcompound.getCompound("BankItems"));
            list.put(slot, inv);
        }
        return list;
    }

    public void writeNBT(HolderLookup.Provider lookupProvider, CompoundTag nbttagcompound) {
        nbttagcompound.putInt("DataBankId", this.bankId);
        nbttagcompound.putInt("UnlockedSlots", this.unlockedSlots);
        nbttagcompound.put("UpdatedSlots", (Tag)NBTTags.nbtBooleanList(this.upgradedSlots));
        nbttagcompound.put("BankInv", (Tag)this.nbtItemSlots(lookupProvider, this.itemSlots));
    }

    private ListTag nbtItemSlots(HolderLookup.Provider lookupProvider, HashMap<Integer, NpcMiscInventory> items) {
        ListTag list = new ListTag();
        for (int slot : items.keySet()) {
            CompoundTag nbttagcompound = new CompoundTag();
            nbttagcompound.putInt("Slot", slot);
            nbttagcompound.put("BankItems", (Tag)items.get(slot).getToNBT(lookupProvider));
            list.add((Object)nbttagcompound);
        }
        return list;
    }

    public boolean isUpgraded(Bank bank, int slot) {
        if (bank.isUpgraded(slot)) {
            return true;
        }
        return bank.canBeUpgraded(slot) && this.upgradedSlots.get(slot) != false;
    }

    public void openBankGui(ServerPlayer player, EntityNPCInterface npc, int bankId, int slot) {
        Bank bank = BankController.getInstance((HolderLookup.Provider)player.level().registryAccess()).getBank(bankId);
        if (bank.getMaxSlots() <= slot) {
            return;
        }
        if (bank.startSlots > this.unlockedSlots) {
            this.unlockedSlots = bank.startSlots;
        }
        ItemStack currency = ItemStack.EMPTY;
        if (this.unlockedSlots <= slot) {
            currency = bank.currencyInventory.getItem(slot);
            NoppesUtilServer.openContainerGui(player, EnumGuiType.PlayerBankUnlock, buf -> {
                buf.writeInt(slot);
                buf.writeInt(bank.id);
            });
        } else if (this.isUpgraded(bank, slot)) {
            NoppesUtilServer.openContainerGui(player, EnumGuiType.PlayerBankLarge, buf -> {
                buf.writeInt(slot);
                buf.writeInt(bank.id);
            });
        } else if (bank.canBeUpgraded(slot)) {
            currency = bank.upgradeInventory.getItem(slot);
            NoppesUtilServer.openContainerGui(player, EnumGuiType.PlayerBankUprade, buf -> {
                buf.writeInt(slot);
                buf.writeInt(bank.id);
            });
        } else {
            NoppesUtilServer.openContainerGui(player, EnumGuiType.PlayerBankSmall, buf -> {
                buf.writeInt(slot);
                buf.writeInt(bank.id);
            });
        }
        ItemStack item = currency;
        CustomNPCsScheduler.runTack(() -> {
            CompoundTag compound = new CompoundTag();
            compound.putInt("MaxSlots", bank.getMaxSlots());
            compound.putInt("UnlockedSlots", this.unlockedSlots);
            if (item != null && !item.isEmpty()) {
                compound.put("Currency", item.save((HolderLookup.Provider)player.registryAccess(), (Tag)new CompoundTag()));
                ContainerNPCBankInterface container = this.getContainer((Player)player);
                if (container != null) {
                    container.setCurrency(item);
                }
            }
            Packets.send(player, new PacketGuiData(compound));
        }, 300);
    }

    private ContainerNPCBankInterface getContainer(Player player) {
        AbstractContainerMenu con = player.containerMenu;
        if (con == null || !(con instanceof ContainerNPCBankInterface)) {
            return null;
        }
        return (ContainerNPCBankInterface)con;
    }
}

