/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.random.Weight;
import net.minecraft.util.random.WeightedEntry;
import noppes.npcs.NBTTags;
import noppes.npcs.controllers.data.CloneSpawnData;

public class SpawnData
implements WeightedEntry {
    public List<ResourceLocation> biomes = new ArrayList<ResourceLocation>();
    public int id = -1;
    public String name = "";
    public Map<Integer, CloneSpawnData> data = new HashMap<Integer, CloneSpawnData>();
    public boolean liquid = false;
    public int type = 0;
    private Weight weight = Weight.of((int)10);

    public void readNBT(CompoundTag compound) {
        this.id = compound.getInt("SpawnId");
        this.name = compound.getString("SpawnName");
        this.setWeight(compound.getInt("SpawnWeight"));
        this.biomes = NBTTags.getResourceLocationList(compound.getList("SpawnBiomes", 10));
        this.data = CloneSpawnData.load(compound.getList("SpawnData", 10));
        this.type = compound.getInt("SpawnType");
    }

    public CompoundTag writeNBT(CompoundTag compound) {
        compound.putInt("SpawnId", this.id);
        compound.putString("SpawnName", this.name);
        compound.putInt("SpawnWeight", this.weight.asInt());
        compound.put("SpawnBiomes", (Tag)NBTTags.nbtResourceLocationList(this.biomes));
        compound.put("SpawnData", (Tag)CloneSpawnData.save(this.data));
        compound.putInt("SpawnType", this.type);
        return compound;
    }

    public void setWeight(int weight) {
        if (weight == 0) {
            weight = 1;
        }
        this.weight = Weight.of((int)weight);
    }

    public void setClone(int slot, int tab, String name) {
        this.data.put(slot, new CloneSpawnData(tab, name));
    }

    public CompoundTag getCompound(int slot) {
        CloneSpawnData sd = this.data.get(slot);
        if (sd == null) {
            return null;
        }
        return sd.getCompound();
    }

    public Weight getWeight() {
        return this.weight;
    }
}

