/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import noppes.npcs.entity.EntityNPCInterface;

public abstract class EntityNPCFlying
extends EntityNPCInterface {
    public EntityNPCFlying(EntityType<? extends PathfinderMob> type, Level world) {
        super(type, world);
    }

    @Override
    public boolean canFly() {
        return this.ais.movementType == 1;
    }

    @Override
    public boolean causeFallDamage(float distance, float damageMultiplier, DamageSource source) {
        if (!this.canFly()) {
            return super.causeFallDamage(distance, damageMultiplier, source);
        }
        return false;
    }

    protected void checkFallDamage(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
        if (!this.canFly()) {
            super.checkFallDamage(y, onGroundIn, state, pos);
        }
    }

    @Override
    public void travel(Vec3 v) {
        if (!this.canFly()) {
            super.travel(v);
            return;
        }
        Vec3 m = this.getDeltaMovement();
        if (!this.isInWater() && this.ais.movementType == 2) {
            m = new Vec3(0.0, -0.15, 0.0);
            this.move(MoverType.SELF, m);
        } else if (this.isInWater() && this.ais.movementType == 1) {
            this.moveRelative(0.02f, v);
            this.move(MoverType.SELF, m);
            m = this.getDeltaMovement().scale(0.8);
        } else if (this.isInLava()) {
            this.moveRelative(0.02f, v);
            this.move(MoverType.SELF, m);
            m = this.getDeltaMovement().scale(0.5);
        } else {
            BlockPos ground = new BlockPos((int)this.getX(), (int)(this.getY() - 1.0), (int)this.getZ());
            float f = 0.91f;
            if (this.onGround()) {
                f = 0.54600006f;
            }
            float f1 = 0.16277137f / (f * f * f);
            f = 0.91f;
            if (this.onGround()) {
                f = 0.54600006f;
            }
            this.moveRelative(this.onGround() ? 0.1f * f1 : 0.02f, v);
            this.move(MoverType.SELF, this.getDeltaMovement());
            m = this.getDeltaMovement().scale((double)f);
        }
        this.setDeltaMovement(m);
        this.calculateEntityAnimation(false);
    }

    public boolean onClimbable() {
        return false;
    }
}

