/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.entity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.protocol.game.ClientboundSetEntityDataPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.goal.RestrictSunGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.damagesource.DamageContainer;
import net.neoforged.neoforge.common.util.FakePlayer;
import noppes.npcs.CustomItems;
import noppes.npcs.CustomNpcs;
import noppes.npcs.EventHooks;
import noppes.npcs.IChatMessages;
import noppes.npcs.NBTTags;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.NpcDamageSource;
import noppes.npcs.VersionCompatibility;
import noppes.npcs.ai.CombatHandler;
import noppes.npcs.ai.EntityAIAnimation;
import noppes.npcs.ai.EntityAIAttackTarget;
import noppes.npcs.ai.EntityAIAvoidTarget;
import noppes.npcs.ai.EntityAIBustDoor;
import noppes.npcs.ai.EntityAIFindShade;
import noppes.npcs.ai.EntityAIFollow;
import noppes.npcs.ai.EntityAIJob;
import noppes.npcs.ai.EntityAILook;
import noppes.npcs.ai.EntityAIMoveIndoors;
import noppes.npcs.ai.EntityAIMovingPath;
import noppes.npcs.ai.EntityAIPanic;
import noppes.npcs.ai.EntityAIPounceTarget;
import noppes.npcs.ai.EntityAIRangedAttack;
import noppes.npcs.ai.EntityAIReturn;
import noppes.npcs.ai.EntityAIRole;
import noppes.npcs.ai.EntityAISprintToTarget;
import noppes.npcs.ai.EntityAITransform;
import noppes.npcs.ai.EntityAIWander;
import noppes.npcs.ai.EntityAIWatchClosest;
import noppes.npcs.ai.EntityAIWaterNav;
import noppes.npcs.ai.EntityAIWorldLines;
import noppes.npcs.ai.FlyingMoveHelper;
import noppes.npcs.ai.NpcGroundPathNavigator;
import noppes.npcs.ai.selector.NPCAttackSelector;
import noppes.npcs.ai.target.EntityAIClearTarget;
import noppes.npcs.ai.target.EntityAIOwnerHurtByTarget;
import noppes.npcs.ai.target.EntityAIOwnerHurtTarget;
import noppes.npcs.ai.target.NpcNearestAttackableTargetGoal;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.constants.PotionEffectType;
import noppes.npcs.api.entity.ICustomNpc;
import noppes.npcs.api.entity.IProjectile;
import noppes.npcs.api.event.NpcEvent;
import noppes.npcs.api.item.IItemStack;
import noppes.npcs.api.wrapper.ItemStackWrapper;
import noppes.npcs.api.wrapper.NPCWrapper;
import noppes.npcs.client.EntityUtil;
import noppes.npcs.client.ISynchedEntityData;
import noppes.npcs.controllers.FactionController;
import noppes.npcs.controllers.LinkedNpcController;
import noppes.npcs.controllers.VisibilityController;
import noppes.npcs.controllers.data.DataTransform;
import noppes.npcs.controllers.data.Dialog;
import noppes.npcs.controllers.data.DialogOption;
import noppes.npcs.controllers.data.Faction;
import noppes.npcs.controllers.data.Line;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.controllers.data.QuestData;
import noppes.npcs.entity.EntityCustomNpc;
import noppes.npcs.entity.EntityProjectile;
import noppes.npcs.entity.data.DataAI;
import noppes.npcs.entity.data.DataAbilities;
import noppes.npcs.entity.data.DataAdvanced;
import noppes.npcs.entity.data.DataDisplay;
import noppes.npcs.entity.data.DataInventory;
import noppes.npcs.entity.data.DataScript;
import noppes.npcs.entity.data.DataStats;
import noppes.npcs.entity.data.DataTimers;
import noppes.npcs.items.ItemDataComponents;
import noppes.npcs.items.ItemSoulstoneFilled;
import noppes.npcs.mixin.EntityIMixin;
import noppes.npcs.mixin.GoalSelectorMixin;
import noppes.npcs.mixinintf.IMixinClientboundAddEntityPacket;
import noppes.npcs.packets.Packets;
import noppes.npcs.packets.client.PacketChatBubble;
import noppes.npcs.packets.client.PacketNpcUpdate;
import noppes.npcs.packets.client.PacketNpcVisibleFalse;
import noppes.npcs.packets.client.PacketNpcVisibleTrue;
import noppes.npcs.packets.client.PacketPlaySound;
import noppes.npcs.packets.client.PacketQuestCompletion;
import noppes.npcs.packets.client.PacketUpdatePhysics;
import noppes.npcs.roles.JobBard;
import noppes.npcs.roles.JobFollower;
import noppes.npcs.roles.JobInterface;
import noppes.npcs.roles.RoleCompanion;
import noppes.npcs.roles.RoleFollower;
import noppes.npcs.roles.RoleInterface;
import noppes.npcs.util.GameProfileAlt;

public abstract class EntityNPCInterface
extends PathfinderMob
implements RangedAttackMob {
    public static final EntityDataAccessor<Boolean> Attacking = SynchedEntityData.defineId(EntityNPCInterface.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    protected static final EntityDataAccessor<Integer> Animation = SynchedEntityData.defineId(EntityNPCInterface.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<String> RoleData = SynchedEntityData.defineId(EntityNPCInterface.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private static final EntityDataAccessor<String> JobData = SynchedEntityData.defineId(EntityNPCInterface.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private static final EntityDataAccessor<Integer> FactionData = SynchedEntityData.defineId(EntityNPCInterface.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> Walking = SynchedEntityData.defineId(EntityNPCInterface.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> Interacting = SynchedEntityData.defineId(EntityNPCInterface.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> IsDead = SynchedEntityData.defineId(EntityNPCInterface.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final GameProfileAlt CommandProfile = new GameProfileAlt();
    public static final GameProfileAlt ChatEventProfile = new GameProfileAlt();
    public static final GameProfileAlt GenericProfile = new GameProfileAlt();
    public static FakePlayer ChatEventPlayer;
    public static FakePlayer CommandPlayer;
    public static FakePlayer GenericPlayer;
    public ICustomNpc wrappedNPC;
    public final DataAbilities abilities = new DataAbilities(this);
    public DataDisplay display = new DataDisplay(this);
    public DataStats stats = new DataStats(this);
    public DataInventory inventory = new DataInventory(this);
    public final DataAI ais = new DataAI(this);
    public final DataAdvanced advanced = new DataAdvanced(this);
    public final DataScript script = new DataScript(this);
    public final DataTransform transform = new DataTransform(this);
    public final DataTimers timers = new DataTimers((Object)this);
    public CombatHandler combatHandler = new CombatHandler(this);
    public String linkedName = "";
    public long linkedLast = 0L;
    public LinkedNpcController.LinkedData linkedData;
    public EntityDimensions baseSize = EntityDimensions.scalable((float)0.6f, (float)1.8f);
    private static final EntityDimensions sizeSleep;
    public float scaleX;
    public float scaleY;
    public float scaleZ;
    private boolean wasKilled = false;
    public RoleInterface role = RoleInterface.NONE;
    public JobInterface job = JobInterface.NONE;
    public HashMap<Integer, DialogOption> dialogs;
    public boolean hasDied = false;
    public long killedtime = 0L;
    public long totalTicksAlive = 0L;
    private int taskCount = 1;
    public int lastInteract = 0;
    public Faction faction;
    private EntityAIRangedAttack aiRange;
    private Goal aiAttackTarget;
    public EntityAILook lookAi;
    public EntityAIAnimation animateAi;
    public List<LivingEntity> interactingEntities = new ArrayList<LivingEntity>();
    public ResourceLocation textureLocation = null;
    public ResourceLocation textureGlowLocation = null;
    public ResourceLocation textureCloakLocation = null;
    public int currentAnimation = 0;
    public int animationStart = 0;
    public int npcVersion = VersionCompatibility.ModRev;
    public IChatMessages messages;
    public boolean updateClient = false;
    public boolean updateAI = false;
    public final ServerBossEvent bossInfo;
    public final HashSet<Integer> tracking = new HashSet();
    public double prevChasingPosX;
    public double prevChasingPosY;
    public double prevChasingPosZ;
    public double chasingPosX;
    public double chasingPosY;
    public double chasingPosZ;
    private double startYPos = -6666.0;

    public EntityNPCInterface(EntityType<? extends PathfinderMob> type, Level world) {
        super(type, world);
        if (!this.isClientSide()) {
            this.wrappedNPC = new NPCWrapper<EntityNPCInterface>(this);
        }
        this.registerBaseAttributes();
        this.dialogs = new HashMap();
        if (!CustomNpcs.DefaultInteractLine.isEmpty()) {
            this.advanced.interactLines.lines.put(0, new Line(CustomNpcs.DefaultInteractLine));
        }
        this.xpReward = 0;
        this.scaleZ = 0.9375f;
        this.scaleY = 0.9375f;
        this.scaleX = 0.9375f;
        this.faction = this.getFaction();
        this.setFaction(this.faction.id);
        this.updateAI = true;
        this.bossInfo = new ServerBossEvent(this.getDisplayName(), BossEvent.BossBarColor.PURPLE, BossEvent.BossBarOverlay.PROGRESS);
        this.bossInfo.setVisible(false);
    }

    public boolean isSensitiveToWater() {
        return false;
    }

    public boolean isPushedByFluid() {
        return this.ais.movementType != 2;
    }

    public LivingEntity getControllingPassenger() {
        return this.getPassengers().isEmpty() || !(this.getPassengers().get(0) instanceof LivingEntity) || !this.ais.mountControl ? null : (LivingEntity)this.getPassengers().get(0);
    }

    private void registerBaseAttributes() {
        this.getAttribute(Attributes.MAX_HEALTH).setBaseValue((double)this.stats.maxHealth);
        this.getAttribute(Attributes.FOLLOW_RANGE).setBaseValue((double)CustomNpcs.NpcNavRange);
        this.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue((double)this.getSpeed());
        this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue((double)this.stats.melee.getStrength());
        this.getAttribute(Attributes.FLYING_SPEED).setBaseValue((double)(this.getSpeed() * 2.0f));
    }

    public static AttributeSupplier.Builder createMobAttributes() {
        return LivingEntity.createLivingAttributes().add(Attributes.ATTACK_DAMAGE).add(Attributes.FLYING_SPEED).add(Attributes.FOLLOW_RANGE);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(RoleData, (Object)String.valueOf(""));
        builder.define(JobData, (Object)String.valueOf(""));
        builder.define(FactionData, (Object)0);
        builder.define(Animation, (Object)0);
        builder.define(Walking, (Object)false);
        builder.define(Interacting, (Object)false);
        builder.define(IsDead, (Object)false);
        builder.define(Attacking, (Object)false);
    }

    public boolean isAlive() {
        return super.isAlive() && !this.isKilled();
    }

    public void tick() {
        super.tick();
        if (this.tickCount % 10 == 0) {
            this.startYPos = this.calculateStartYPos(this.ais.startPos()) + 1.0;
            if (this.startYPos < (double)this.level().getMinBuildHeight() && !this.isClientSide()) {
                this.discard();
            }
            EventHooks.onNPCTick(this);
        }
        this.timers.update();
        if (this.level().isClientSide && this.wasKilled != this.isKilled() && this.wasKilled) {
            this.deathTime = 0;
            this.refreshDimensions();
        }
        this.wasKilled = this.isKilled();
        if (this.currentAnimation == 14) {
            this.deathTime = 19;
        }
    }

    public boolean doHurtTarget(Entity par1Entity) {
        Holder.Reference damageTypeHolder;
        boolean var4;
        float f = this.stats.melee.getStrength();
        if (this.stats.melee.getDelay() < 10) {
            par1Entity.invulnerableTime = 0;
        }
        if (par1Entity instanceof LivingEntity) {
            NpcEvent.MeleeAttackEvent event = new NpcEvent.MeleeAttackEvent(this.wrappedNPC, (LivingEntity)par1Entity, f);
            if (EventHooks.onNPCAttacksMelee(this, event)) {
                return false;
            }
            f = event.damage;
        }
        if (var4 = par1Entity.hurt(new DamageSource((Holder)(damageTypeHolder = this.level().registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolderOrThrow(NpcDamageSource.NPC)), (Entity)this), f)) {
            if (this.getOwner() instanceof Player) {
                EntityUtil.setRecentlyHit((LivingEntity)par1Entity);
            }
            if (this.stats.melee.getKnockback() > 0) {
                par1Entity.push((double)(-Mth.sin((float)(this.getYRot() * (float)Math.PI / 180.0f)) * (float)this.stats.melee.getKnockback() * 0.5f), 0.1, (double)(Mth.cos((float)(this.getYRot() * (float)Math.PI / 180.0f)) * (float)this.stats.melee.getKnockback() * 0.5f));
                this.setDeltaMovement(this.getDeltaMovement().multiply(0.6, 1.0, 0.6));
            }
            if (this.role.getType() == 6) {
                ((RoleCompanion)this.role).attackedEntity(par1Entity);
            }
        }
        if (this.stats.melee.getEffectType() != 0) {
            if (this.stats.melee.getEffectType() != 666) {
                ((LivingEntity)par1Entity).addEffect(new MobEffectInstance((Holder)PotionEffectType.getHolder(this.stats.melee.getEffectType()).get(), this.stats.melee.getEffectTime() * 20, this.stats.melee.getEffectStrength()));
            } else {
                par1Entity.setRemainingFireTicks(this.stats.melee.getEffectTime() * 20);
            }
        }
        return var4;
    }

    public void aiStep() {
        float f;
        if (CustomNpcs.FreezeNPCs) {
            return;
        }
        if (this.isNoAi()) {
            super.aiStep();
            return;
        }
        ++this.totalTicksAlive;
        this.updateSwingTime();
        if (this.tickCount % 20 == 0) {
            this.faction = this.getFaction();
        }
        if (!this.level().isClientSide) {
            if (!this.isKilled() && this.tickCount % 20 == 0) {
                this.advanced.scenes.update();
                if (this.getHealth() < this.getMaxHealth()) {
                    if (this.stats.healthRegen > 0 && !this.isAttacking()) {
                        this.heal(this.stats.healthRegen);
                    }
                    if (this.stats.combatRegen > 0 && this.isAttacking()) {
                        this.heal(this.stats.combatRegen);
                    }
                }
                if (this.faction.getsAttacked && !this.isAttacking()) {
                    List list = this.level().getEntitiesOfClass(Monster.class, this.getBoundingBox().inflate(16.0, 16.0, 16.0));
                    for (Monster mob : list) {
                        if (mob.getTarget() != null || !this.canNpcSee((Entity)mob)) continue;
                        mob.setTarget((LivingEntity)this);
                    }
                }
                if (this.linkedData != null && this.linkedData.time > this.linkedLast) {
                    LinkedNpcController.Instance.loadNpcData(this);
                }
                if (this.updateClient) {
                    this.updateClient();
                }
                if (this.updateAI) {
                    this.updateTasks();
                    this.updateAI = false;
                }
            }
            if (this.getHealth() <= 0.0f && !this.isKilled()) {
                this.removeAllEffects();
                this.entityData.set(IsDead, (Object)true);
                this.updateTasks();
                this.refreshDimensions();
            }
            if (this.display.getBossbar() == 2) {
                this.bossInfo.setVisible(this.getTarget() != null);
            }
            this.entityData.set(Walking, (Object)(!this.getNavigation().isDone() ? 1 : 0));
            this.entityData.set(Interacting, (Object)this.isInteracting());
            this.combatHandler.update();
            this.onCollide();
        }
        if (this.wasKilled != this.isKilled() && this.wasKilled) {
            this.reset();
        }
        if (this.level().isDay() && !this.level().isClientSide && this.stats.burnInSun && (f = this.getLightLevelDependentMagicValue()) > 0.5f && this.random.nextFloat() * 30.0f < (f - 0.4f) * 2.0f && this.level().canSeeSky(this.blockPosition())) {
            this.setRemainingFireTicks(160);
        }
        super.aiStep();
        if (this.level().isClientSide) {
            this.role.clientUpdate();
            if (this.textureCloakLocation != null) {
                this.cloakUpdate();
            }
            if (this.currentAnimation != (Integer)this.entityData.get(Animation)) {
                this.currentAnimation = (Integer)this.entityData.get(Animation);
                this.animationStart = this.tickCount;
                this.refreshDimensions();
            }
            if (this.job.getType() == 1) {
                ((JobBard)this.job).aiStep();
            }
        }
        if (this.display.getBossbar() > 0) {
            this.bossInfo.setProgress(this.getHealth() / this.getMaxHealth());
        }
    }

    public void updateClient() {
        Packets.sendNearby((Entity)this, new PacketNpcUpdate(this.getId(), this.writeSpawnData()));
        this.updateClient = false;
    }

    protected InteractionResult mobInteract(Player player, InteractionHand hand) {
        if (this.level().isClientSide) {
            return this.isAttacking() ? InteractionResult.FAIL : InteractionResult.PASS;
        }
        if (hand != InteractionHand.MAIN_HAND) {
            return InteractionResult.PASS;
        }
        ItemStack stack = player.getItemInHand(hand);
        if (stack != null) {
            Item item = stack.getItem();
            if (item == CustomItems.cloner || item == CustomItems.wand || item == CustomItems.mount || item == CustomItems.scripter) {
                this.setTarget(null);
                this.setLastHurtByMob(null);
                return InteractionResult.SUCCESS;
            }
            if (item == CustomItems.moving) {
                this.setTarget(null);
                stack.set(ItemDataComponents.NPCID, (Object)this.getId());
                player.sendSystemMessage((Component)Component.translatable((String)"message.pather.register", (Object[])new Object[]{this.getName()}));
                return InteractionResult.SUCCESS;
            }
        }
        if (EventHooks.onNPCInteract(this, player)) {
            return InteractionResult.FAIL;
        }
        if (this.getFaction().isAggressiveToPlayer(player) || this.isAttacking()) {
            return InteractionResult.FAIL;
        }
        this.addInteract((LivingEntity)player);
        Dialog dialog = this.getDialog(player);
        QuestData data = PlayerData.get((Player)player).questData.getQuestCompletion(player, this);
        if (data != null) {
            Packets.send((ServerPlayer)player, new PacketQuestCompletion(data.quest.id));
        } else if (dialog != null) {
            NoppesUtilServer.openDialog(player, this, dialog);
        } else if (this.role.getType() != 0) {
            this.role.interact(player);
        } else {
            this.say(player, this.advanced.getInteractLine());
        }
        return InteractionResult.PASS;
    }

    public void addInteract(LivingEntity entity) {
        if (!this.ais.stopAndInteract || this.isAttacking() || !entity.isAlive() || this.isNoAi()) {
            return;
        }
        if (this.tickCount - this.lastInteract < 180) {
            this.interactingEntities.clear();
        }
        this.getNavigation().stop();
        this.lastInteract = this.tickCount;
        if (!this.interactingEntities.contains(entity)) {
            this.interactingEntities.add(entity);
        }
    }

    public boolean isInteracting() {
        if (this.tickCount - this.lastInteract < 40 || this.isClientSide() && ((Boolean)this.entityData.get(Interacting)).booleanValue()) {
            return true;
        }
        return this.ais.stopAndInteract && !this.interactingEntities.isEmpty() && this.tickCount - this.lastInteract < 180;
    }

    private Dialog getDialog(Player player) {
        for (DialogOption option : this.dialogs.values()) {
            if (option == null || !option.hasDialog()) continue;
            Dialog dialog = option.getDialog();
            if (!dialog.availability.isAvailable(player)) continue;
            return dialog;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hurt(DamageSource damagesource, float i) {
        if (this.level().isClientSide || CustomNpcs.FreezeNPCs || damagesource.getMsgId().equals("inWall")) {
            return false;
        }
        if (damagesource.getMsgId().equals("outOfLevel") && this.isKilled()) {
            this.reset();
        }
        i = this.stats.resistances.applyResistance(damagesource, i);
        float f = this.invulnerableTime;
        Objects.requireNonNull(this);
        if (f > 20.0f / 2.0f && i <= this.lastHurt) {
            return false;
        }
        Entity entity = NoppesUtilServer.GetDamageSourcee(damagesource);
        LivingEntity attackingEntity = null;
        if (entity instanceof LivingEntity) {
            attackingEntity = (LivingEntity)entity;
        }
        if (attackingEntity != null && attackingEntity == this.getOwner()) {
            return false;
        }
        if (attackingEntity instanceof EntityNPCInterface) {
            EntityNPCInterface npc = (EntityNPCInterface)attackingEntity;
            if (npc.faction.id == this.faction.id) {
                return false;
            }
            if (npc.getOwner() instanceof Player) {
                this.hurtTime = 100;
            }
        } else if (attackingEntity instanceof Player && this.faction.isFriendlyToPlayer((Player)attackingEntity)) {
            return false;
        }
        NpcEvent.DamagedEvent event = new NpcEvent.DamagedEvent(this.wrappedNPC, entity, i, damagesource);
        if (EventHooks.onNPCDamaged(this, event)) {
            return false;
        }
        i = event.damage;
        if (this.isKilled()) {
            return false;
        }
        if (attackingEntity == null) {
            return super.hurt(damagesource, i);
        }
        try {
            if (this.isAttacking()) {
                if (this.getTarget() != null && this.distanceToSqr((Entity)this.getTarget()) > this.distanceToSqr((Entity)attackingEntity)) {
                    this.setTarget(attackingEntity);
                }
                boolean bl = super.hurt(damagesource, i);
                return bl;
            }
            if (i > 0.0f) {
                List inRange = this.level().getEntitiesOfClass(EntityNPCInterface.class, this.getBoundingBox().inflate(32.0, 16.0, 32.0));
                for (EntityNPCInterface npc : inRange) {
                    if (npc.isKilled() || !npc.advanced.defendFaction || npc.faction.id != this.faction.id || !npc.canNpcSee((Entity)this) && !npc.ais.directLOS && !npc.canNpcSee((Entity)attackingEntity)) continue;
                    npc.onAttack(attackingEntity);
                }
                this.setTarget(attackingEntity);
            }
            boolean bl = super.hurt(damagesource, i);
            return bl;
        }
        finally {
            if (event.clearTarget) {
                this.setTarget(null);
                this.setLastHurtByMob(null);
            }
        }
    }

    protected void actuallyHurt(DamageSource damageSrc, float damageAmount) {
        super.actuallyHurt(damageSrc, damageAmount);
        this.combatHandler.damage(damageSrc, damageAmount);
    }

    public void onAttack(LivingEntity entity) {
        if (entity == null || entity == this || this.isAttacking() || this.ais.onAttack == 3 || entity == this.getOwner()) {
            return;
        }
        super.setTarget(entity);
    }

    public void setTarget(LivingEntity entity) {
        Line line;
        if (entity instanceof Player && ((Player)entity).getAbilities().invulnerable || entity != null && entity == this.getOwner() || this.getTarget() == entity) {
            return;
        }
        if (entity != null) {
            Object event = new NpcEvent.TargetEvent(this.wrappedNPC, (LivingEntity)entity);
            if (EventHooks.onNPCTarget(this, event)) {
                return;
            }
            entity = ((NpcEvent.TargetEvent)((Object)event)).entity == null ? null : ((NpcEvent.TargetEvent)((Object)event)).entity.getMCEntity();
        } else {
            for (WrappedGoal en : this.targetSelector.getAvailableGoals()) {
                en.stop();
            }
            if (EventHooks.onNPCTargetLost(this, this.getTarget())) {
                return;
            }
        }
        if (entity != null && entity != this && this.ais.onAttack != 3 && !this.isAttacking() && !this.isClientSide() && (line = this.advanced.getAttackLine()) != null) {
            this.saySurrounding(Line.formatTarget(line, entity));
        }
        super.setTarget(entity);
    }

    public void performRangedAttack(LivingEntity entity, float f) {
        ItemStack proj = ItemStackWrapper.MCItem(this.inventory.getProjectile());
        if (proj == null) {
            this.updateAI = true;
            return;
        }
        NpcEvent.RangedLaunchedEvent event = new NpcEvent.RangedLaunchedEvent(this.wrappedNPC, entity, this.stats.ranged.getStrength());
        for (int i = 0; i < this.stats.ranged.getShotCount(); ++i) {
            EntityProjectile projectile = this.shoot(entity, this.stats.ranged.getAccuracy(), proj, f == 1.0f);
            projectile.damage = event.damage;
            projectile.callback = (projectile1, pos, entity1) -> {
                SoundEvent sound;
                Entity e;
                if (proj.getItem() == CustomItems.soulstoneFull && (e = ItemSoulstoneFilled.Spawn(null, proj, this.level(), pos)) instanceof LivingEntity && entity1 instanceof LivingEntity) {
                    if (e instanceof Mob) {
                        ((Mob)e).setTarget((LivingEntity)entity1);
                    } else {
                        ((LivingEntity)e).setLastHurtByMob((LivingEntity)entity1);
                    }
                }
                if ((sound = this.stats.ranged.getSoundEvent(entity1 != null ? 1 : 2)) != null) {
                    projectile1.playSound(sound, 1.0f, 1.2f / (this.getRandom().nextFloat() * 0.2f + 0.9f));
                }
                return false;
            };
            SoundEvent sound = this.stats.ranged.getSoundEvent(0);
            if (sound != null) {
                this.playSound(sound, 2.0f, 1.0f);
            }
            event.projectiles.add((IProjectile)NpcAPI.Instance().getIEntity((Entity)projectile));
        }
        EventHooks.onNPCRangedLaunched(this, event);
    }

    public EntityProjectile shoot(LivingEntity entity, int accuracy, ItemStack proj, boolean indirect) {
        return this.shoot(entity.getX(), entity.getBoundingBox().minY + (double)(entity.getBbHeight() / 2.0f), entity.getZ(), accuracy, proj, indirect);
    }

    public EntityProjectile shoot(double x, double y, double z, int accuracy, ItemStack proj, boolean indirect) {
        EntityProjectile projectile = new EntityProjectile(this.level(), (LivingEntity)this, proj.copy(), true);
        double varX = x - this.getX();
        double varY = y - (this.getY() + (double)this.getEyeHeight());
        double varZ = z - this.getZ();
        float varF = projectile.hasGravity() ? (float)Math.sqrt(varX * varX + varZ * varZ) : 0.0f;
        float angle = projectile.getAngleForXYZ(varX, varY, varZ, varF, indirect);
        float acc = 20.0f - (float)Mth.floor((float)((float)accuracy / 5.0f));
        projectile.shoot(varX, varY, varZ, angle, acc);
        this.level().addFreshEntity((Entity)projectile);
        return projectile;
    }

    private void clearTasks(GoalSelector tasks) {
        ArrayList list = new ArrayList(tasks.getAvailableGoals());
        for (WrappedGoal entityaitaskentry : list) {
            tasks.removeGoal((Goal)entityaitaskentry);
        }
        tasks.getAvailableGoals().clear();
        ((GoalSelectorMixin)tasks).lockedFlags().clear();
        ((GoalSelectorMixin)tasks).disabledFlags().clear();
    }

    private void updateTasks() {
        if (this.level() == null || this.level().isClientSide || !(this.level() instanceof ServerLevel)) {
            return;
        }
        ServerLevel sLevel = (ServerLevel)this.level();
        this.clearTasks(this.goalSelector);
        this.clearTasks(this.targetSelector);
        if (this.isKilled()) {
            return;
        }
        this.targetSelector.addGoal(0, (Goal)new EntityAIClearTarget(this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, new NpcNearestAttackableTargetGoal<LivingEntity>(this, LivingEntity.class, 4, this.ais.directLOS, false, (Predicate<LivingEntity>)((Object)new NPCAttackSelector(this))));
        this.targetSelector.addGoal(3, (Goal)new EntityAIOwnerHurtByTarget(this));
        this.targetSelector.addGoal(4, (Goal)new EntityAIOwnerHurtTarget(this));
        if (this.ais.movementType == 1) {
            this.moveControl = new FlyingMoveHelper(this);
            if (!(this.navigation instanceof FlyingPathNavigation)) {
                this.navigation = new FlyingPathNavigation(this, (Mob)this, this.level()){

                    public boolean isStableDestination(BlockPos p_26439_) {
                        return true;
                    }
                };
            }
        } else if (this.ais.movementType == 2) {
            this.moveControl = new FlyingMoveHelper(this);
            if (!(this.navigation instanceof WaterBoundPathNavigation)) {
                this.navigation = new WaterBoundPathNavigation((Mob)this, this.level());
            }
        } else {
            this.moveControl = new MoveControl((Mob)this);
            if (!(this.navigation instanceof GroundPathNavigation)) {
                this.navigation = new NpcGroundPathNavigator((Mob)this, this.level());
            }
            this.goalSelector.addGoal(0, (Goal)new EntityAIWaterNav(this));
        }
        this.taskCount = 1;
        this.addRegularEntries();
        this.doorInteractType();
        this.seekShelter();
        this.setResponse();
        this.setMoveType();
    }

    protected PathNavigation createNavigation(Level p_21480_) {
        return new NpcGroundPathNavigator((Mob)this, p_21480_);
    }

    private void setResponse() {
        this.aiRange = null;
        this.aiAttackTarget = null;
        if (this.ais.canSprint) {
            this.goalSelector.addGoal(this.taskCount++, (Goal)new EntityAISprintToTarget(this));
        }
        if (this.ais.onAttack == 1) {
            this.goalSelector.addGoal(this.taskCount++, (Goal)new EntityAIPanic(this, 1.2f));
        } else if (this.ais.onAttack == 2) {
            this.goalSelector.addGoal(this.taskCount++, (Goal)new EntityAIAvoidTarget(this));
        } else if (this.ais.onAttack == 0) {
            if (this.ais.canLeap) {
                this.goalSelector.addGoal(this.taskCount++, (Goal)new EntityAIPounceTarget(this));
            }
            this.aiAttackTarget = new EntityAIAttackTarget(this);
            this.goalSelector.addGoal(this.taskCount, this.aiAttackTarget);
            if (this.inventory.getProjectile() != null) {
                this.aiRange = new EntityAIRangedAttack(this);
                this.goalSelector.addGoal(this.taskCount++, (Goal)this.aiRange);
            }
        } else if (this.ais.onAttack == 3) {
            // empty if block
        }
    }

    public boolean canFly() {
        return this.navigation instanceof FlyingPathNavigation;
    }

    public void setMoveType() {
        if (this.ais.getMovingType() == 1) {
            this.goalSelector.addGoal(this.taskCount++, (Goal)new EntityAIWander(this));
        }
        if (this.ais.getMovingType() == 2) {
            this.goalSelector.addGoal(this.taskCount++, (Goal)new EntityAIMovingPath(this));
        }
    }

    public void doorInteractType() {
        if (this.navigation instanceof GroundPathNavigation) {
            Object aiDoor = null;
            if (this.ais.doorInteract == 1) {
                aiDoor = new OpenDoorGoal((Mob)this, true);
                this.goalSelector.addGoal(this.taskCount++, (Goal)aiDoor);
            } else if (this.ais.doorInteract == 0) {
                aiDoor = new EntityAIBustDoor((Mob)this);
                this.goalSelector.addGoal(this.taskCount++, (Goal)aiDoor);
            }
            ((GroundPathNavigation)this.navigation).setCanOpenDoors(aiDoor != null);
        }
    }

    public void seekShelter() {
        if (this.ais.findShelter == 0) {
            this.goalSelector.addGoal(this.taskCount++, (Goal)new EntityAIMoveIndoors(this));
        } else if (this.ais.findShelter == 1) {
            if (!this.canFly()) {
                this.goalSelector.addGoal(this.taskCount++, (Goal)new RestrictSunGoal((PathfinderMob)this));
            }
            this.goalSelector.addGoal(this.taskCount++, (Goal)new EntityAIFindShade(this));
        }
    }

    public void addRegularEntries() {
        this.goalSelector.addGoal(this.taskCount++, (Goal)new EntityAIReturn(this));
        this.goalSelector.addGoal(this.taskCount++, (Goal)new EntityAIFollow(this));
        if (this.ais.getStandingType() != 1 && this.ais.getStandingType() != 3) {
            this.goalSelector.addGoal(this.taskCount++, (Goal)new EntityAIWatchClosest(this, LivingEntity.class, 5.0f));
        }
        this.lookAi = new EntityAILook(this);
        this.goalSelector.addGoal(this.taskCount++, (Goal)this.lookAi);
        this.goalSelector.addGoal(this.taskCount++, (Goal)new EntityAIWorldLines(this));
        this.goalSelector.addGoal(this.taskCount++, (Goal)new EntityAIJob(this));
        this.goalSelector.addGoal(this.taskCount++, (Goal)new EntityAIRole(this));
        this.animateAi = new EntityAIAnimation(this);
        this.goalSelector.addGoal(this.taskCount++, (Goal)this.animateAi);
        if (this.transform.isValid()) {
            this.goalSelector.addGoal(this.taskCount++, (Goal)new EntityAITransform(this));
        }
    }

    public float getSpeed() {
        return (float)this.ais.getWalkingSpeed() / 20.0f;
    }

    protected float getWaterSlowDown() {
        return this.ais.movementType == 2 ? 0.95f : 0.8f;
    }

    public float getWalkTargetValue(BlockPos pos) {
        if (this.ais.movementType == 2) {
            return this.isInWater() ? 10.0f : 0.0f;
        }
        float weight = (float)this.level().getLightEmission(pos) - 0.5f;
        if (this.level().getBlockState(pos).isSolidRender((BlockGetter)this.level(), pos)) {
            weight += 10.0f;
        }
        return weight;
    }

    protected int decreaseAirSupply(int par1) {
        if (!this.stats.canDrown) {
            return par1;
        }
        return super.decreaseAirSupply(par1);
    }

    public Set<String> getTags() {
        return super.getTags();
    }

    public TagKey<EntityType<?>> getMobType() {
        return this.stats == null ? null : this.stats.creatureType;
    }

    public int getAmbientSoundInterval() {
        return 160;
    }

    public void playAmbientSound() {
        if (!this.isAlive()) {
            return;
        }
        this.advanced.playSound(this.getTarget() != null ? 1 : 0, this.getSoundVolume(), this.getVoicePitch());
    }

    protected void playHurtSound(DamageSource source) {
        this.advanced.playSound(2, this.getSoundVolume(), this.getVoicePitch());
    }

    public SoundEvent getDeathSound() {
        return null;
    }

    public float getVoicePitch() {
        if (this.advanced.disablePitch) {
            return 1.0f;
        }
        return super.getVoicePitch();
    }

    protected void playStepSound(BlockPos pos, BlockState state) {
        if (this.advanced.getSound(4) != null) {
            this.advanced.playSound(4, 0.15f, 1.0f);
        } else {
            super.playStepSound(pos, state);
        }
    }

    public ServerPlayer getFakeChatPlayer() {
        if (this.level().isClientSide) {
            return null;
        }
        EntityUtil.Copy((LivingEntity)this, (LivingEntity)ChatEventPlayer);
        EntityNPCInterface.ChatEventProfile.npc = this;
        ((EntityIMixin)ChatEventPlayer).setLevel((Level)((ServerLevel)this.level()));
        ChatEventPlayer.setPos(this.getX(), this.getY(), this.getZ());
        return ChatEventPlayer;
    }

    public void saySurrounding(Line line) {
        if (line == null) {
            return;
        }
        if (!line.getShowText() || !line.getText().isEmpty()) {
            // empty if block
        }
        List inRange = this.level().getEntitiesOfClass(Player.class, this.getBoundingBox().inflate(20.0, 20.0, 20.0));
        for (Player player : inRange) {
            this.say(player, line);
        }
    }

    public void say(Player player, Line line) {
        if (line == null || !this.canNpcSee((Entity)player)) {
            return;
        }
        if (!line.getSound().isEmpty()) {
            BlockPos pos = this.blockPosition();
            Packets.send((ServerPlayer)player, new PacketPlaySound(line.getSound(), pos, this.getSoundVolume(), this.getVoicePitch()));
        }
        if (!line.getText().isEmpty()) {
            Packets.send((ServerPlayer)player, new PacketChatBubble(this.getId(), (Component)Component.translatable((String)line.getText()), line.getShowText()));
        }
    }

    public boolean shouldShowName() {
        return true;
    }

    public void push(double d, double d1, double d2) {
        if (this.isWalking() && !this.isKilled()) {
            super.push(d, d1, d2);
        }
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.npcVersion = compound.getInt("ModRev");
        VersionCompatibility.CheckNpcCompatibility(this, compound);
        this.display.readToNBT(compound);
        this.stats.readToNBT(compound);
        this.ais.readToNBT(compound);
        this.script.load(compound);
        this.timers.load(compound);
        this.advanced.readToNBT(compound);
        this.role.load(compound);
        this.job.load(compound);
        this.inventory.load(compound);
        this.transform.readToNBT(compound);
        this.killedtime = compound.getLong("KilledTime");
        this.totalTicksAlive = compound.getLong("TotalTicksAlive");
        this.linkedName = compound.getString("LinkedNpcName");
        if (!this.isClientSide()) {
            LinkedNpcController.Instance.loadNpcData(this);
        }
        this.getAttribute(Attributes.FOLLOW_RANGE).setBaseValue((double)CustomNpcs.NpcNavRange);
        this.updateAI = true;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        this.display.save(compound);
        this.stats.save(compound);
        this.ais.save(compound);
        this.script.save(compound);
        this.timers.save(compound);
        this.advanced.save(compound);
        this.role.save(compound);
        this.job.save(compound);
        this.inventory.save(compound);
        this.transform.save(compound);
        compound.putLong("KilledTime", this.killedtime);
        compound.putLong("TotalTicksAlive", this.totalTicksAlive);
        compound.putInt("ModRev", this.npcVersion);
        compound.putString("LinkedNpcName", this.linkedName);
    }

    public EntityDimensions getDimensions(Pose poseIn) {
        EntityDimensions size = this.baseSize;
        if (this.currentAnimation == 2 || this.currentAnimation == 7 || this.deathTime > 0) {
            size = sizeSleep;
        } else if (this.isPassenger() || this.currentAnimation == 1) {
            size = this.baseSize.scale(1.0f, 0.77f);
        }
        size = size.scale((float)this.display.getSize() * 0.2f);
        if (this.display.getHitboxState() == 1 || this.isKilled() && this.stats.hideKilledBody) {
            size = EntityDimensions.scalable((float)1.0E-5f, (float)size.height());
        }
        return size;
    }

    public void tickDeath() {
        if (this.stats.spawnCycle == 3 || this.stats.spawnCycle == 4) {
            super.tickDeath();
            return;
        }
        ++this.deathTime;
        if (this.level().isClientSide) {
            return;
        }
        if (!this.hasDied) {
            this.remove(Entity.RemovalReason.KILLED);
        }
        if (this.killedtime < System.currentTimeMillis() && (this.stats.spawnCycle == 0 || this.level().isDay() && this.stats.spawnCycle == 1 || !this.level().isDay() && this.stats.spawnCycle == 2)) {
            this.reset();
        }
    }

    public void reset() {
        boolean needsSync = this.hasDied;
        this.hasDied = false;
        this.unsetRemoved();
        this.dead = false;
        this.wasKilled = false;
        this.setSprinting(false);
        this.setHealth(this.getMaxHealth());
        this.entityData.set(Animation, (Object)0);
        this.entityData.set(Walking, (Object)false);
        this.entityData.set(IsDead, (Object)false);
        this.entityData.set(Interacting, (Object)false);
        this.interactingEntities.clear();
        this.combatHandler.reset();
        this.setTarget(null);
        this.setLastHurtByMob(null);
        this.deathTime = 0;
        if (this.ais.returnToStart && !this.hasOwner() && !this.isClientSide() && !this.isPassenger()) {
            this.moveTo(this.getStartXPos(), this.getStartYPos(), this.getStartZPos(), this.getYRot(), this.getXRot());
        }
        this.killedtime = 0L;
        this.clearFire();
        this.removeAllEffects();
        this.travel(Vec3.ZERO);
        this.walkDist = 0.0f;
        this.walkDistO = 0.0f;
        this.getNavigation().stop();
        this.currentAnimation = 0;
        this.refreshDimensions();
        this.updateAI = true;
        this.ais.movingPos = 0;
        if (this.getOwner() != null) {
            this.getOwner().setLastHurtMob(null);
        }
        this.bossInfo.setVisible(this.display.getBossbar() == 1);
        this.job.reset();
        EventHooks.onNPCInit(this);
        if (needsSync) {
            List data = this.getEntityData().getNonDefaultValues();
            for (ServerPlayer player : this.level().getServer().getPlayerList().getPlayers()) {
                if (!this.display.isVisibleTo(player) && !player.isSpectator() && player.getMainHandItem().getItem() != CustomItems.wand) continue;
                Packets.send(player, new PacketUpdatePhysics((Entity)this));
                if (data != null) {
                    player.connection.send((Packet)new ClientboundSetEntityDataPacket(this.getId(), data));
                }
                Packets.send(player, new PacketNpcUpdate(this.getId(), this.writeSpawnData()));
            }
        }
    }

    public void onCollide() {
        if (!this.isAlive() || this.tickCount % 4 != 0 || this.level().isClientSide) {
            return;
        }
        AABB axisalignedbb = null;
        axisalignedbb = this.getVehicle() != null && this.getVehicle().isAlive() ? this.getBoundingBox().minmax(this.getVehicle().getBoundingBox()).inflate(1.0, 0.0, 1.0) : this.getBoundingBox().inflate(1.0, 0.5, 1.0);
        List list = this.level().getEntitiesOfClass(LivingEntity.class, axisalignedbb);
        if (list == null) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            Entity entity = (Entity)list.get(i);
            if (entity == this || !entity.isAlive()) continue;
            EventHooks.onNPCCollide(this, entity);
        }
    }

    public void cloakUpdate() {
        this.prevChasingPosX = this.chasingPosX;
        this.prevChasingPosY = this.chasingPosY;
        this.prevChasingPosZ = this.chasingPosZ;
        double d0 = this.getX() - this.chasingPosX;
        double d1 = this.getY() - this.chasingPosY;
        double d2 = this.getZ() - this.chasingPosZ;
        double d3 = 10.0;
        if (d0 > 10.0) {
            this.prevChasingPosX = this.chasingPosX = this.getX();
        }
        if (d2 > 10.0) {
            this.prevChasingPosZ = this.chasingPosZ = this.getZ();
        }
        if (d1 > 10.0) {
            this.prevChasingPosY = this.chasingPosY = this.getY();
        }
        if (d0 < -10.0) {
            this.prevChasingPosX = this.chasingPosX = this.getX();
        }
        if (d2 < -10.0) {
            this.prevChasingPosZ = this.chasingPosZ = this.getZ();
        }
        if (d1 < -10.0) {
            this.prevChasingPosY = this.chasingPosY = this.getY();
        }
        this.chasingPosX += d0 * 0.25;
        this.chasingPosZ += d2 * 0.25;
        this.chasingPosY += d1 * 0.25;
    }

    public boolean removeWhenFarAway(double distanceToPlayer) {
        return this.stats != null && this.stats.spawnCycle == 4;
    }

    public ItemStack getMainHandItem() {
        IItemStack item = null;
        item = this.isAttacking() ? this.inventory.getRightHand() : (this.role.getType() == 6 ? ((RoleCompanion)this.role).getItemInHand() : (this.job.overrideMainHand ? this.job.getMainhand() : this.inventory.getRightHand()));
        return ItemStackWrapper.MCItem(item);
    }

    public ItemStack getOffhandItem() {
        IItemStack item = null;
        item = this.isAttacking() ? this.inventory.getLeftHand() : (this.job.overrideOffHand ? this.job.getOffhand() : this.inventory.getLeftHand());
        return ItemStackWrapper.MCItem(item);
    }

    public ItemStack getItemBySlot(EquipmentSlot slot) {
        if (slot == EquipmentSlot.MAINHAND) {
            return this.getMainHandItem();
        }
        if (slot == EquipmentSlot.OFFHAND) {
            return this.getOffhandItem();
        }
        return ItemStackWrapper.MCItem(this.inventory.getArmor(3 - slot.getIndex()));
    }

    public void setItemSlot(EquipmentSlot slot, ItemStack item) {
        if (slot == EquipmentSlot.MAINHAND) {
            this.inventory.weapons.put(0, NpcAPI.Instance().getIItemStack(item));
        } else if (slot == EquipmentSlot.OFFHAND) {
            this.inventory.weapons.put(2, NpcAPI.Instance().getIItemStack(item));
        } else {
            this.inventory.armor.put(3 - slot.getIndex(), NpcAPI.Instance().getIItemStack(item));
        }
    }

    public Iterable<ItemStack> getArmorSlots() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (int i = 0; i < 4; ++i) {
            list.add(ItemStackWrapper.MCItem(this.inventory.armor.get(3 - i)));
        }
        return list;
    }

    public Iterable<ItemStack> getAllSlots() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        list.add(ItemStackWrapper.MCItem(this.inventory.weapons.get(0)));
        list.add(ItemStackWrapper.MCItem(this.inventory.weapons.get(2)));
        return list;
    }

    protected void dropCustomDeathLoot(ServerLevel level, DamageSource damageSource, boolean recentlyHit) {
    }

    protected void dropFromLootTable(DamageSource damageSourceIn, boolean attackedRecently) {
    }

    public void die(DamageSource damagesource) {
        this.setSprinting(false);
        this.getNavigation().stop();
        this.clearFire();
        this.removeAllEffects();
        if (!this.isClientSide()) {
            this.advanced.playSound(3, this.getSoundVolume(), this.getVoicePitch());
            Entity attackingEntity = NoppesUtilServer.GetDamageSourcee(damagesource);
            NpcEvent.DiedEvent event = new NpcEvent.DiedEvent(this.wrappedNPC, damagesource, attackingEntity);
            event.droppedItems = this.inventory.getItemsRNG();
            event.expDropped = this.inventory.getExpRNG();
            event.line = this.advanced.getKilledLine();
            EventHooks.onNPCDied(this, event);
            this.bossInfo.setVisible(false);
            this.inventory.dropStuff(event, attackingEntity, damagesource);
            if (event.line != null) {
                this.saySurrounding(Line.formatTarget((Line)event.line, attackingEntity instanceof LivingEntity ? (LivingEntity)attackingEntity : null));
            }
        }
        super.die(damagesource);
    }

    public void startSeenByPlayer(ServerPlayer player) {
        super.startSeenByPlayer(player);
        this.bossInfo.addPlayer(player);
    }

    public void stopSeenByPlayer(ServerPlayer player) {
        super.stopSeenByPlayer(player);
        this.bossInfo.removePlayer(player);
    }

    public void remove(Entity.RemovalReason reason) {
        if (reason != Entity.RemovalReason.KILLED) {
            super.remove(reason);
            return;
        }
        this.hasDied = true;
        this.ejectPassengers();
        this.stopRiding();
        if (this.level().isClientSide || this.stats.spawnCycle == 3 || this.stats.spawnCycle == 4) {
            this.delete();
        } else {
            this.setHealth(-1.0f);
            this.setSprinting(false);
            this.getNavigation().stop();
            this.setCurrentAnimation(2);
            this.refreshDimensions();
            if (this.killedtime <= 0L) {
                this.killedtime = (long)(this.stats.respawnTime * 1000) + System.currentTimeMillis();
            }
            this.role.killed();
            this.job.killed();
        }
    }

    public void delete() {
        VisibilityController.instance.remove(this);
        this.role.delete();
        this.job.delete();
        super.remove(Entity.RemovalReason.DISCARDED);
    }

    public float getStartXPos() {
        return (float)this.ais.startPos().getX() + this.ais.bodyOffsetX / 10.0f;
    }

    public float getStartZPos() {
        return (float)this.ais.startPos().getZ() + this.ais.bodyOffsetZ / 10.0f;
    }

    public boolean isVeryNearAssignedPlace() {
        double xx = this.getX() - (double)this.getStartXPos();
        double zz = this.getZ() - (double)this.getStartZPos();
        if (xx < -0.2 || xx > 0.2) {
            return false;
        }
        return !(zz < -0.2) && !(zz > 0.2);
    }

    public double getStartYPos() {
        if (this.startYPos < (double)this.level().getMinBuildHeight()) {
            return this.calculateStartYPos(this.ais.startPos());
        }
        return this.startYPos;
    }

    private double calculateStartYPos(BlockPos pos) {
        BlockPos startPos = this.ais.startPos();
        while (pos.getY() > this.level().getMinBuildHeight()) {
            BlockState state = this.level().getBlockState(pos);
            VoxelShape shape = state.getShape((BlockGetter)this.level(), pos);
            if (shape.isEmpty()) {
                pos = pos.below();
                continue;
            }
            AABB bb = shape.bounds().move(pos);
            if (this.ais.movementType == 2 && startPos.getY() <= pos.getY() && state.is(Blocks.WATER)) {
                pos = pos.below();
                continue;
            }
            return bb.maxY;
        }
        return this.level().getMinBuildHeight();
    }

    private BlockPos calculateTopPos(BlockPos pos) {
        BlockPos check = pos;
        while (check.getY() > this.level().getMinBuildHeight()) {
            AABB bb;
            BlockState state = this.level().getBlockState(pos);
            VoxelShape shape = state.getShape((BlockGetter)this.level(), pos);
            if (!shape.isEmpty() && (bb = shape.bounds().move(pos)) != null) {
                return check;
            }
            check = check.below();
        }
        return pos;
    }

    public boolean isInRange(Entity entity, double range) {
        return this.isInRange(entity.getX(), entity.getY(), entity.getZ(), range);
    }

    public boolean isInRange(double posX, double posY, double posZ, double range) {
        double y = Math.abs(this.getY() - posY);
        if (posY >= (double)this.level().getMinBuildHeight() && y > range) {
            return false;
        }
        double x = Math.abs(this.getX() - posX);
        double z = Math.abs(this.getZ() - posZ);
        return x <= range && z <= range;
    }

    public void givePlayerItem(Player player, ItemStack item) {
        if (this.level().isClientSide) {
            return;
        }
        item = item.copy();
        float f = 0.7f;
        double d = (double)(this.level().random.nextFloat() * f) + (double)(1.0f - f);
        double d1 = (double)(this.level().random.nextFloat() * f) + (double)(1.0f - f);
        double d2 = (double)(this.level().random.nextFloat() * f) + (double)(1.0f - f);
        ItemEntity entityitem = new ItemEntity(this.level(), this.getX() + d, this.getY() + d1, this.getZ() + d2, item);
        entityitem.setPickUpDelay(2);
        this.level().addFreshEntity((Entity)entityitem);
        int i = item.getCount();
        if (player.getInventory().add(item)) {
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.2f, ((this.random.nextFloat() - this.random.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            player.take((Entity)entityitem, i);
            if (item.getCount() <= 0) {
                entityitem.discard();
            }
        }
    }

    public boolean isSleeping() {
        return this.currentAnimation == 2 && !this.isAttacking();
    }

    public boolean isWalking() {
        return this.ais.getMovingType() != 0 || this.isAttacking() || this.isFollower() || (Boolean)this.entityData.get(Walking) != false;
    }

    public boolean isCrouching() {
        return this.currentAnimation == 4;
    }

    public void knockback(double strength, double ratioX, double ratioZ) {
        super.knockback(strength * (double)(2.0f - this.stats.resistances.knockback), ratioX, ratioZ);
    }

    public Faction getFaction() {
        Faction fac = FactionController.instance.getFaction((Integer)this.entityData.get(FactionData));
        if (fac == null) {
            return FactionController.instance.getFaction(FactionController.instance.getFirstFactionId());
        }
        return fac;
    }

    public boolean isClientSide() {
        return this.level() == null || this.level().isClientSide;
    }

    public void setFaction(int id) {
        if (id < 0 || this.isClientSide()) {
            return;
        }
        this.entityData.set(FactionData, (Object)id);
    }

    public boolean canBeAffected(MobEffectInstance effect) {
        if (this.stats.potionImmune) {
            return false;
        }
        if (this.getMobType() == EntityTypeTags.ARTHROPOD && effect.getEffect() == MobEffects.POISON) {
            return false;
        }
        return super.canBeAffected(effect);
    }

    public boolean isAttacking() {
        return (Boolean)this.entityData.get(Attacking);
    }

    public boolean isKilled() {
        return this.isRemoved() || (Boolean)this.entityData.get(IsDead) != false;
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        buffer.writeNbt((Tag)this.writeSpawnData());
    }

    public CompoundTag writeSpawnData() {
        CompoundTag bard;
        CompoundTag compound = new CompoundTag();
        this.display.save(compound);
        compound.putInt("MaxHealth", this.stats.maxHealth);
        compound.put("Armor", (Tag)NBTTags.nbtIItemStackMap((HolderLookup.Provider)this.registryAccess(), this.inventory.armor));
        compound.put("Weapons", (Tag)NBTTags.nbtIItemStackMap((HolderLookup.Provider)this.registryAccess(), this.inventory.weapons));
        compound.putInt("Speed", this.ais.getWalkingSpeed());
        compound.putBoolean("MountControl", this.ais.mountControl);
        compound.putBoolean("DeadBody", this.stats.hideKilledBody);
        compound.putInt("StandingState", this.ais.getStandingType());
        compound.putInt("MovingState", this.ais.getMovingType());
        compound.putInt("Orientation", this.ais.orientation);
        compound.putFloat("PositionXOffset", this.ais.bodyOffsetX);
        compound.putFloat("PositionYOffset", this.ais.bodyOffsetY);
        compound.putFloat("PositionZOffset", this.ais.bodyOffsetZ);
        compound.putInt("Role", this.role.getType());
        compound.putInt("Job", this.job.getType());
        if (this.job.getType() == 1) {
            bard = new CompoundTag();
            this.job.save(bard);
            compound.put("Bard", (Tag)bard);
        }
        if (this.job.getType() == 9) {
            bard = new CompoundTag();
            this.job.save(bard);
            compound.put("Puppet", (Tag)bard);
        }
        if (this.role.getType() == 6) {
            bard = new CompoundTag();
            this.role.save(bard);
            compound.put("Companion", (Tag)bard);
        }
        if (this instanceof EntityCustomNpc) {
            compound.put("ModelData", (Tag)((EntityCustomNpc)this).modelData.save());
        }
        return compound;
    }

    public void readSpawnData(FriendlyByteBuf buf) {
        this.readSpawnData(buf.readNbt());
    }

    public void readSpawnData(CompoundTag compound) {
        CompoundTag puppet;
        this.stats.setMaxHealth(compound.getInt("MaxHealth"));
        this.ais.setWalkingSpeed(compound.getInt("Speed"));
        this.stats.hideKilledBody = compound.getBoolean("DeadBody");
        this.ais.setStandingType(compound.getInt("StandingState"));
        this.ais.mountControl = compound.getBoolean("MountControl");
        this.ais.setMovingType(compound.getInt("MovingState"));
        this.ais.orientation = compound.getInt("Orientation");
        this.ais.bodyOffsetX = compound.getFloat("PositionXOffset");
        this.ais.bodyOffsetY = compound.getFloat("PositionYOffset");
        this.ais.bodyOffsetZ = compound.getFloat("PositionZOffset");
        this.inventory.armor = NBTTags.getIItemStackMap((HolderLookup.Provider)this.registryAccess(), compound.getList("Armor", 10));
        this.inventory.weapons = NBTTags.getIItemStackMap((HolderLookup.Provider)this.registryAccess(), compound.getList("Weapons", 10));
        this.advanced.setRole(compound.getInt("Role"));
        this.advanced.setJob(compound.getInt("Job"));
        if (this.job.getType() == 1) {
            CompoundTag bard = compound.getCompound("Bard");
            this.job.load(bard);
        }
        if (this.job.getType() == 9) {
            puppet = compound.getCompound("Puppet");
            this.job.load(puppet);
        }
        if (this.role.getType() == 6) {
            puppet = compound.getCompound("Companion");
            this.role.load(puppet);
        }
        if (this instanceof EntityCustomNpc) {
            ((EntityCustomNpc)this).modelData.load(compound.getCompound("ModelData"));
        }
        this.display.readToNBT(compound);
        this.refreshDimensions();
    }

    public CommandSourceStack createCommandSourceStack() {
        if (this.level().isClientSide) {
            return super.createCommandSourceStack();
        }
        EntityUtil.Copy((LivingEntity)this, (LivingEntity)CommandPlayer);
        ((EntityIMixin)CommandPlayer).setLevel((Level)((ServerLevel)this.level()));
        CommandPlayer.setPos(this.getX(), this.getY(), this.getZ());
        return new CommandSourceStack((CommandSource)this, this.position(), this.getRotationVector(), this.level() instanceof ServerLevel ? (ServerLevel)this.level() : null, this.getPermissionLevel(), this.getName().getString(), this.getDisplayName(), this.level().getServer(), (Entity)this);
    }

    public Component getName() {
        return Component.translatable((String)this.display.getName());
    }

    public void setImmuneToFire(boolean immuneToFire) {
        this.stats.immuneToFire = immuneToFire;
    }

    public boolean fireImmune() {
        return this.stats.immuneToFire;
    }

    public boolean causeFallDamage(float distance, float modifier, DamageSource source) {
        if (!this.stats.noFallDamage) {
            return super.causeFallDamage(distance, modifier, source);
        }
        return false;
    }

    public void makeStuckInBlock(BlockState state, Vec3 motionMultiplierIn) {
        if (state != null && !state.is(Blocks.COBWEB) || !this.stats.ignoreCobweb) {
            super.makeStuckInBlock(state, motionMultiplierIn);
        }
    }

    public boolean canBeCollidedWith() {
        return !this.isKilled() && this.display.getHitboxState() == 2;
    }

    protected void pushEntities() {
        if (this.display.getHitboxState() != 0) {
            return;
        }
        super.pushEntities();
    }

    public boolean isPushable() {
        return this.isWalking() && !this.isKilled();
    }

    public PushReaction getPistonPushReaction() {
        return this.display.getHitboxState() == 0 ? super.getPistonPushReaction() : PushReaction.IGNORE;
    }

    public EntityAIRangedAttack getRangedTask() {
        return this.aiRange;
    }

    public String getRoleData() {
        return (String)this.entityData.get(RoleData);
    }

    public void setRoleData(String s) {
        this.entityData.set(RoleData, (Object)s);
    }

    public String getJobData() {
        return (String)this.entityData.get(RoleData);
    }

    public void setJobData(String s) {
        this.entityData.set(RoleData, (Object)s);
    }

    public Level getCommandSenderWorld() {
        return this.level();
    }

    public boolean isInvisibleTo(Player player) {
        return this.display.getVisible() == 1 && player.getMainHandItem().getItem() != CustomItems.wand && !this.display.availability.hasOptions();
    }

    public boolean isInvisible() {
        return this.display.getVisible() != 0 && !this.display.availability.hasOptions();
    }

    public void setInvisible(ServerPlayer playerMP) {
        if (this.tracking.contains(playerMP.getId())) {
            this.tracking.remove(playerMP.getId());
            Packets.send(playerMP, new PacketNpcVisibleFalse(this.getId()));
        }
    }

    public void setVisible(ServerPlayer playerMP) {
        if (!this.tracking.contains(playerMP.getId())) {
            this.tracking.add(playerMP.getId());
            Packets.send(playerMP, new PacketNpcVisibleTrue((Entity)this));
            List data = this.getEntityData().getNonDefaultValues();
            if (data != null) {
                playerMP.connection.send((Packet)new ClientboundSetEntityDataPacket(this.getId(), data));
            }
        }
        Packets.send(playerMP, new PacketNpcUpdate(this.getId(), this.writeSpawnData()));
    }

    public void setCurrentAnimation(int animation) {
        this.currentAnimation = animation;
        this.entityData.set(Animation, (Object)animation);
    }

    public boolean canNpcSee(Entity entity) {
        return this.getSensing().hasLineOfSight(entity);
    }

    public boolean isFollower() {
        if (this.advanced.scenes.getOwner() != null) {
            return true;
        }
        return this.role.isFollowing() || this.job.isFollowing();
    }

    public LivingEntity getOwner() {
        if (this.advanced.scenes.getOwner() != null) {
            return this.advanced.scenes.getOwner();
        }
        if (this.role.getType() == 2 && this.role instanceof RoleFollower) {
            return ((RoleFollower)this.role).owner;
        }
        if (this.role.getType() == 6 && this.role instanceof RoleCompanion) {
            return ((RoleCompanion)this.role).owner;
        }
        if (this.job.getType() == 5 && this.job instanceof JobFollower) {
            return ((JobFollower)this.job).following;
        }
        return null;
    }

    public boolean hasOwner() {
        if (this.advanced.scenes.getOwner() != null) {
            return true;
        }
        return this.role.getType() == 2 && ((RoleFollower)this.role).hasOwner() || this.role.getType() == 6 && ((RoleCompanion)this.role).hasOwner() || this.job.getType() == 5 && ((JobFollower)this.job).hasOwner();
    }

    public int followRange() {
        if (this.advanced.scenes.getOwner() != null) {
            return 4;
        }
        if (this.role.getType() == 2 && this.role.isFollowing()) {
            return 6;
        }
        if (this.role.getType() == 6 && this.role.isFollowing()) {
            return 4;
        }
        if (this.job.getType() == 5 && this.job.isFollowing()) {
            return 4;
        }
        return 15;
    }

    protected float getDamageAfterArmorAbsorb(DamageSource source, float damage) {
        if (this.role.getType() == 6) {
            damage = ((RoleCompanion)this.role).getDamageAfterArmorAbsorb(source, damage);
        }
        return damage;
    }

    public boolean isAlliedTo(Entity entity) {
        if (!this.isClientSide()) {
            if (entity instanceof Player && this.getFaction().isFriendlyToPlayer((Player)entity)) {
                return true;
            }
            if (entity == this.getOwner()) {
                return true;
            }
            if (entity instanceof EntityNPCInterface && ((EntityNPCInterface)entity).faction.id == this.faction.id) {
                return true;
            }
        }
        return super.isAlliedTo(entity);
    }

    public void setDataWatcher(SynchedEntityData entityData) {
        ArrayList<SynchedEntityData.DataValue> list = new ArrayList<SynchedEntityData.DataValue>();
        for (SynchedEntityData.DataItem<?> entry : ((ISynchedEntityData)entityData).getAll()) {
            if (!(entry.getValue() instanceof SynchedEntityData.DataValue)) continue;
            list.add((SynchedEntityData.DataValue)entry.getValue());
        }
        this.entityData.assignValues(list);
    }

    public void travel(Vec3 travelVector) {
        BlockPos pos = this.blockPosition();
        if (this.isAlive() && this.isVehicle() && this.ais.mountControl && this.getControllingPassenger() != null) {
            LivingEntity livingentity = this.getControllingPassenger();
            this.setYRot(livingentity.getYRot());
            this.yRotO = this.getYRot();
            this.setXRot(livingentity.getXRot() * 0.5f);
            this.setRot(this.getYRot(), this.getXRot());
            this.yHeadRot = this.yBodyRot = this.getYRot();
            float f = livingentity.xxa * 0.5f;
            float f1 = livingentity.zza;
            if (f1 <= 0.0f) {
                f1 *= 0.25f;
            }
            this.getAttribute(Attributes.STEP_HEIGHT).setBaseValue((double)1.1f);
            super.travel(new Vec3((double)f, travelVector.y, (double)f1));
        } else {
            this.getAttribute(Attributes.STEP_HEIGHT).setBaseValue(0.5);
            super.travel(travelVector);
        }
        if (this.role.getType() == 6 && !this.isClientSide()) {
            BlockPos delta = this.blockPosition().subtract((Vec3i)pos);
            ((RoleCompanion)this.role).addMovementStat(delta.getX(), delta.getY(), delta.getZ());
        }
    }

    public boolean canBeLeashed() {
        return false;
    }

    public boolean isLeashed() {
        return false;
    }

    public boolean nearPosition(BlockPos pos) {
        BlockPos npcpos = this.blockPosition();
        float x = npcpos.getX() - pos.getX();
        float z = npcpos.getZ() - pos.getZ();
        float y = npcpos.getY() - pos.getY();
        float height = Mth.ceil((float)(this.getBbHeight() + 1.0f)) * Mth.ceil((float)(this.getBbHeight() + 1.0f));
        return (double)(x * x + z * z) < 2.5 && (double)(y * y) < (double)height + 2.5;
    }

    public void tpTo(LivingEntity owner) {
        if (owner == null) {
            return;
        }
        Direction facing = owner.getDirection().getOpposite();
        BlockPos pos = new BlockPos((int)owner.getX(), (int)owner.getBoundingBox().minY, (int)owner.getZ());
        pos = pos.offset(facing.getStepX(), 0, facing.getStepZ());
        pos = this.calculateTopPos(pos);
        block0: for (int i = -1; i < 2; ++i) {
            for (int j = 0; j < 3; ++j) {
                BlockPos check = facing.getStepX() == 0 ? pos.offset(i, 0, j * facing.getStepZ()) : pos.offset(j * facing.getStepX(), 0, i);
                check = this.calculateTopPos(check);
                if (this.level().getBlockState(check).isSolidRender((BlockGetter)this.level(), check) || this.level().getBlockState(check.above()).isSolidRender((BlockGetter)this.level(), check.above())) continue;
                this.moveTo((float)check.getX() + 0.5f, check.getY(), (float)check.getZ() + 0.5f, this.getYRot(), this.getXRot());
                this.getNavigation().stop();
                continue block0;
            }
        }
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> para) {
        super.onSyncedDataUpdated(para);
        if (Animation.equals(para)) {
            this.refreshDimensions();
        }
    }

    protected void updateControlFlags() {
        boolean flag1 = !(this.getVehicle() instanceof Boat);
        this.goalSelector.setControlFlag(Goal.Flag.MOVE, true);
        this.goalSelector.setControlFlag(Goal.Flag.JUMP, flag1);
        this.goalSelector.setControlFlag(Goal.Flag.LOOK, true);
    }

    public void checkDespawn() {
        double range;
        double d0;
        Player entity;
        super.checkDespawn();
        if (this.getNoActionTime() != 0 && this.level() != null && (entity = this.level().getNearestPlayer((Entity)this, -1.0)) != null && (d0 = entity.distanceToSqr((Entity)this)) < (range = (double)this.ais.activeRange * (double)this.ais.activeRange)) {
            this.noActionTime = 0;
        }
    }

    public void recreateFromPacket(ClientboundAddEntityPacket packet) {
        super.recreateFromPacket(packet);
        if (((IMixinClientboundAddEntityPacket)packet).getBuf().isReadable()) {
            this.readSpawnData(((IMixinClientboundAddEntityPacket)packet).getBuf());
        }
    }

    protected float getDamageAfterMagicAbsorb(DamageSource damageSource, float damageAmount) {
        int i;
        int j;
        float f;
        float f1;
        float f2;
        if (damageSource.is(DamageTypeTags.BYPASSES_EFFECTS)) {
            return damageAmount;
        }
        if (this.hasEffect(MobEffects.DAMAGE_RESISTANCE) && !damageSource.is(DamageTypeTags.BYPASSES_RESISTANCE) && (f2 = (f1 = damageAmount) - (damageAmount = Math.max((f = damageAmount * (float)(j = 25 - (i = (this.getEffect(MobEffects.DAMAGE_RESISTANCE).getAmplifier() + 1) * 5))) / 25.0f, 0.0f))) > 0.0f && f2 < 3.4028235E37f) {
            ((DamageContainer)this.damageContainers.peek()).setReduction(DamageContainer.Reduction.MOB_EFFECTS, f2);
            if (damageSource.getEntity() instanceof ServerPlayer) {
                ((ServerPlayer)damageSource.getEntity()).awardStat(Stats.DAMAGE_DEALT_RESISTED, Math.round(f2 * 10.0f));
            }
        }
        return Math.max(damageAmount, 0.0f);
    }

    static {
        sizeSleep = EntityDimensions.scalable((float)0.8f, (float)0.4f);
    }
}

