/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.mixin;

import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.entity.BlockEntity;
import noppes.npcs.entity.data.IEntityPersistentData;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BlockEntity.class})
public class BlockEntityPersistentData
implements IEntityPersistentData {
    @Unique
    private CompoundTag CNPC_tag;

    @Override
    @Unique
    public CompoundTag getPersistentData() {
        if (this.CNPC_tag == null) {
            this.CNPC_tag = new CompoundTag();
        }
        return this.CNPC_tag;
    }

    @Inject(method={"saveAdditional"}, at={@At(value="TAIL")})
    public void save(CompoundTag tag, HolderLookup.Provider registries, CallbackInfo ci) {
        if (this.CNPC_tag != null) {
            tag.put("CNPC_persistantData", (Tag)this.CNPC_tag);
        }
    }

    @Inject(method={"loadWithComponents"}, at={@At(value="TAIL")})
    public void read(CompoundTag compound, HolderLookup.Provider registries, CallbackInfo ci) {
        if (compound.contains("CNPC_persistantData")) {
            this.CNPC_tag = compound.getCompound("CNPC_persistantData");
        }
    }
}

