/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.packets.client;

import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.world.entity.Entity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import noppes.npcs.client.ChatMessages;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.shared.client.util.NoppesStringUtils;
import noppes.npcs.shared.common.PacketBasic;

public class PacketChatBubble
extends PacketBasic {
    private final int id;
    private final Component message;
    private final boolean showMessage;

    public PacketChatBubble(int id, Component message, boolean showMessage) {
        this.id = id;
        this.message = message;
        this.showMessage = showMessage;
    }

    public static void encode(PacketChatBubble msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.id);
        buf.writeJsonWithCodec(ComponentSerialization.CODEC, (Object)msg.message);
        buf.writeBoolean(msg.showMessage);
    }

    public static PacketChatBubble decode(FriendlyByteBuf buf) {
        return new PacketChatBubble(buf.readInt(), (Component)buf.readJsonWithCodec(ComponentSerialization.CODEC), buf.readBoolean());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void handle() {
        Entity entity = Minecraft.getInstance().level.getEntity(this.id);
        if (entity == null || !(entity instanceof EntityNPCInterface)) {
            return;
        }
        EntityNPCInterface npc = (EntityNPCInterface)entity;
        if (npc.messages == null) {
            npc.messages = new ChatMessages();
        }
        String text = NoppesStringUtils.formatText(this.message, new Object[]{this.player, npc});
        npc.messages.addMessage(text, npc);
        if (this.showMessage) {
            this.player.sendSystemMessage((Component)Component.literal((String)(npc.getName().getString() + ": ")).append((Component)Component.translatable((String)text)));
        }
    }
}

