/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.packets.client;

import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import noppes.npcs.client.EntityUtil;
import noppes.npcs.controllers.data.Dialog;
import noppes.npcs.entity.EntityDialogNpc;
import noppes.npcs.packets.client.PacketDialog;
import noppes.npcs.shared.common.PacketBasic;

public class PacketDialogDummy
extends PacketBasic {
    private final String name;
    private final CompoundTag data;

    public PacketDialogDummy(String name, CompoundTag data) {
        this.name = name;
        this.data = data;
    }

    public static void encode(PacketDialogDummy msg, FriendlyByteBuf buf) {
        buf.writeUtf(msg.name);
        buf.writeNbt((Tag)msg.data);
    }

    public static PacketDialogDummy decode(FriendlyByteBuf buf) {
        return new PacketDialogDummy(buf.readUtf(Short.MAX_VALUE), buf.readNbt());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void handle() {
        EntityDialogNpc npc = new EntityDialogNpc(this.player.level());
        npc.display.setName(I18n.get((String)this.name, (Object[])new Object[0]));
        EntityUtil.Copy((LivingEntity)this.player, (LivingEntity)npc);
        Dialog dialog = new Dialog(null);
        dialog.readNBT((HolderLookup.Provider)this.player.registryAccess(), this.data);
        PacketDialog.openDialog(dialog, npc, this.player);
    }
}

