/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.shared.client.gui.components;

import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import noppes.npcs.client.gui.util.GuiTooltipUtils;
import noppes.npcs.shared.client.gui.components.GuiButtonNop;
import noppes.npcs.shared.client.gui.components.GuiCustomScrollNop;
import noppes.npcs.shared.client.gui.components.GuiLabel;
import noppes.npcs.shared.client.gui.components.GuiMenuSideButton;
import noppes.npcs.shared.client.gui.components.GuiMenuTopButton;
import noppes.npcs.shared.client.gui.components.GuiSliderNop;
import noppes.npcs.shared.client.gui.components.GuiTextFieldNop;
import noppes.npcs.shared.client.gui.components.GuiWrapper;
import noppes.npcs.shared.client.gui.listeners.IGui;
import noppes.npcs.shared.client.gui.listeners.IGuiInterface;

public class GuiBasicContainer<T extends AbstractContainerMenu>
extends AbstractContainerScreen<T>
implements IGuiInterface {
    public boolean drawDefaultBackground = true;
    public int guiLeft;
    public int guiTop;
    public LocalPlayer player;
    public GuiWrapper wrapper = new GuiWrapper((Screen)this);
    public String title;
    public boolean closeOnEsc = true;
    public int mouseX;
    public int mouseY;

    public GuiBasicContainer(T cont, Inventory inv, Component titleIn) {
        super(cont, inv, titleIn);
        this.player = Minecraft.getInstance().player;
        this.title = "";
        this.minecraft = Minecraft.getInstance();
        this.font = this.minecraft.font;
    }

    public boolean shouldCloseOnEsc() {
        return this.closeOnEsc;
    }

    public void init() {
        super.init();
        this.setFocused(null);
        this.guiLeft = (this.width - this.imageWidth) / 2;
        this.guiTop = (this.height - this.imageHeight) / 2;
        this.renderables.clear();
        this.children().clear();
        this.wrapper.init(this.minecraft, this.width, this.height);
    }

    public ResourceLocation getResource(String texture) {
        return new ResourceLocation("customnpcs", "textures/gui/" + texture);
    }

    public void containerTick() {
        this.wrapper.tick();
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrolled, double arg4) {
        if (this.wrapper.mouseScrolled(mouseX, mouseY, scrolled, arg4)) {
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, scrolled, arg4);
    }

    public boolean mouseClicked(double i, double j, int k) {
        if (this.wrapper.mouseClicked(i, j, k)) {
            return true;
        }
        return super.mouseClicked(i, j, k);
    }

    public boolean mouseDragged(double x, double y, int button, double dx, double dy) {
        if (this.wrapper.mouseDragged(x, y, button, dx, dy)) {
            return true;
        }
        if (this.getFocused() != null && this.isDragging() && button == 0) {
            this.getFocused().mouseDragged(x, y, button, dx, dy);
            return true;
        }
        return super.mouseDragged(x, y, button, dx, dy);
    }

    public boolean mouseReleased(double x, double y, int button) {
        if (this.wrapper.mouseReleased(x, y, button)) {
            return true;
        }
        return super.mouseReleased(x, y, button);
    }

    @Override
    public void elementClicked() {
        if (this.wrapper.subgui != null) {
            ((IGuiInterface)this.wrapper.subgui).elementClicked();
        }
    }

    @Override
    public void subGuiClosed(Screen subgui) {
    }

    @Override
    public GuiWrapper getWrapper() {
        return this.wrapper;
    }

    @Override
    public void initGui() {
        this.init();
    }

    public boolean isInventoryKey(int i) {
        return this.minecraft.options.keyInventory.getKey().getValue() == i;
    }

    public boolean charTyped(char c, int i) {
        if (this.wrapper.charTyped(c, i)) {
            return true;
        }
        return super.charTyped(c, i);
    }

    public boolean keyPressed(int key, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (this.wrapper.keyPressed(key, p_keyPressed_2_, p_keyPressed_3_)) {
            return true;
        }
        return super.keyPressed(key, p_keyPressed_2_, p_keyPressed_3_);
    }

    public void setFocused(GuiEventListener gui) {
        if (this.wrapper.subgui != null) {
            this.wrapper.subgui.setFocused(gui);
        } else {
            if (gui != null && !this.children().contains(gui)) {
                return;
            }
            this.wrapper.changeFocus(this.getFocused(), gui);
            super.setFocused(gui);
        }
    }

    public GuiEventListener getFocused() {
        if (this.wrapper.subgui != null) {
            return this.wrapper.subgui.getFocused();
        }
        return super.getFocused();
    }

    public void buttonEvent(Button guibutton) {
    }

    public void close() {
        this.save();
        this.player.closeContainer();
        this.setScreen(null);
        this.minecraft.mouseHandler.grabMouse();
    }

    public void onClose() {
        this.close();
        GuiTextFieldNop.unfocus();
    }

    public void addButton(GuiButtonNop button) {
        this.wrapper.npcbuttons.put(button.id, button);
        super.addRenderableWidget((GuiEventListener)button);
    }

    public void addTopButton(GuiMenuTopButton button) {
        this.wrapper.topbuttons.put(button.id, button);
        super.addRenderableWidget((GuiEventListener)button);
    }

    public void addSideButton(GuiMenuSideButton button) {
        this.wrapper.sidebuttons.put(button.id, button);
        super.addRenderableWidget((GuiEventListener)button);
    }

    public GuiButtonNop getButton(int i) {
        return this.wrapper.npcbuttons.get(i);
    }

    public GuiMenuSideButton getSideButton(int i) {
        return this.wrapper.sidebuttons.get(i);
    }

    public GuiMenuTopButton getTopButton(int i) {
        return this.wrapper.topbuttons.get(i);
    }

    public void addTextField(GuiTextFieldNop tf) {
        this.wrapper.textfields.put(tf.id, tf);
    }

    public GuiTextFieldNop getTextField(int i) {
        return this.wrapper.textfields.get(i);
    }

    public void add(IGui gui) {
        this.wrapper.components.add(gui);
    }

    public IGui get(int id) {
        for (IGui comp : this.wrapper.components) {
            if (comp.getID() != id) continue;
            return comp;
        }
        return null;
    }

    public void addLabel(GuiLabel label) {
        this.wrapper.labels.put(label.id, label);
    }

    public GuiLabel getLabel(int i) {
        return this.wrapper.labels.get(i);
    }

    public void addSlider(GuiSliderNop slider) {
        this.wrapper.sliders.put(slider.id, slider);
        this.addRenderableWidget((GuiEventListener)slider);
    }

    public GuiSliderNop getSlider(int i) {
        return this.wrapper.sliders.get(i);
    }

    public void addScroll(GuiCustomScrollNop scroll) {
        scroll.init(this.minecraft, scroll.width, scroll.height);
        this.wrapper.scrolls.put(scroll.id, scroll);
    }

    public GuiCustomScrollNop getScroll(int id) {
        return this.wrapper.scrolls.get(id);
    }

    protected void renderLabels(GuiGraphics p_281635_, int p_282681_, int p_283686_) {
    }

    protected void renderBg(GuiGraphics graphics, float partialTicks, int x, int y) {
    }

    @Override
    public void buttonEvent(GuiButtonNop button) {
    }

    @Override
    public void save() {
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBg(graphics, partialTicks, mouseX, mouseY);
        this.wrapper.mouseX = mouseX;
        this.wrapper.mouseY = mouseY;
        this.mouseX = mouseX;
        this.mouseY = mouseY;
        ArrayList slots = new ArrayList(this.menu.slots);
        if (this.wrapper.subgui != null) {
            this.menu.slots.clear();
        }
        boolean drawDefBack = this.drawDefaultBackground;
        this.drawDefaultBackground = false;
        super.render(graphics, mouseX, mouseY, partialTicks);
        this.drawDefaultBackground = drawDefBack;
        graphics.drawCenteredString(this.getFontRenderer(), I18n.get((String)this.title, (Object[])new Object[0]), this.width / 2, this.guiTop - 8, 0xFFFFFF);
        for (GuiLabel label : new ArrayList<GuiLabel>(this.wrapper.labels.values())) {
            label.render(graphics, mouseX, mouseY, partialTicks);
        }
        for (GuiTextFieldNop tf : new ArrayList<GuiTextFieldNop>(this.wrapper.textfields.values())) {
            tf.renderWidget(graphics, mouseX, mouseY, partialTicks);
        }
        for (GuiCustomScrollNop scroll : new ArrayList<GuiCustomScrollNop>(this.wrapper.scrolls.values())) {
            scroll.render(graphics, mouseX, mouseY, partialTicks);
        }
        for (IGui comp : new ArrayList<IGui>(this.wrapper.components)) {
            comp.render(graphics, mouseX, mouseY);
            for (Screen gui : new ArrayList<Screen>(this.wrapper.extra.values())) {
                gui.render(graphics, mouseX, mouseY, partialTicks);
            }
        }
        if (this.wrapper.subgui != null) {
            this.menu.slots.addAll(slots);
            graphics.pose().pushPose();
            graphics.pose().translate(0.0f, 0.0f, 100.0f);
            this.wrapper.subgui.render(graphics, mouseX, mouseY, partialTicks);
            graphics.pose().popPose();
        } else {
            this.renderTooltip(graphics, mouseX, mouseY);
        }
    }

    public void renderTooltip(GuiGraphics p_283594_, int p_282171_, int p_281909_) {
        if (this.menu.getCarried().isEmpty() && this.hoveredSlot != null && this.hoveredSlot.hasItem()) {
            ItemStack itemstack = this.hoveredSlot.getItem();
            GuiTooltipUtils.renderTooltip(p_283594_, this.font, this.getTooltipFromContainerItem(itemstack), itemstack.getTooltipImage(), itemstack, p_282171_, p_281909_);
        }
    }

    public void renderBackground(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.drawDefaultBackground && this.wrapper.subgui == null) {
            this.superRenderBackground(graphics, mouseX, mouseY, partialTicks);
        }
    }

    public void superRenderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderTransparentBackground(guiGraphics);
    }

    public Font getFontRenderer() {
        return this.font;
    }

    public void setScreen(Screen gui) {
        this.minecraft.setScreen(gui);
    }

    public void setSubGui(Screen gui) {
        this.wrapper.setSubgui(gui);
        this.init();
    }

    @Override
    public boolean hasSubGui() {
        return this.wrapper.subgui != null;
    }

    @Override
    public Screen getSubGui() {
        return this.wrapper.getSubGui();
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public Screen getParent() {
        return this.wrapper.getParent();
    }
}

