/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.capability;

import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.helper.TamableType;

public class EnhancedFamiliarHandler {
    private static final ResourceLocation ARMOR_TOUGHNESS = ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"enhanced_familiar_armor_toughness");
    private static final ResourceLocation ARMOR = ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"enhanced_familiar_armor");
    private static final ResourceLocation ATTACK_DAMAGE = ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"enhanced_familiar_attack_damage");
    private static final String ENHANCED_FAMILIAR = "tb_enhanced_familiar";

    public static boolean hasCapability(@Nullable Entity entity) {
        LivingEntity livingEntity;
        return entity instanceof LivingEntity && TamableType.getType(livingEntity = (LivingEntity)entity) != null;
    }

    public static boolean isEnhanced(Entity entity) {
        return entity.getPersistentData().getBoolean(ENHANCED_FAMILIAR);
    }

    public static void setEnhanced(Entity entity) {
        entity.getPersistentData().putBoolean(ENHANCED_FAMILIAR, true);
    }

    public static void applyAttributes(LivingEntity livingEntity) {
        Optional.ofNullable(livingEntity.getAttribute(Attributes.ARMOR_TOUGHNESS)).ifPresent(attributeInstance -> attributeInstance.addTransientModifier(new AttributeModifier(ARMOR_TOUGHNESS, 1.0, AttributeModifier.Operation.ADD_VALUE)));
        Optional.ofNullable(livingEntity.getAttribute(Attributes.ARMOR)).ifPresent(attributeInstance -> attributeInstance.addTransientModifier(new AttributeModifier(ARMOR, 1.0, AttributeModifier.Operation.ADD_MULTIPLIED_BASE)));
        Optional.ofNullable(livingEntity.getAttribute(Attributes.ATTACK_DAMAGE)).ifPresent(attributeInstance -> attributeInstance.addTransientModifier(new AttributeModifier(ATTACK_DAMAGE, 1.0, AttributeModifier.Operation.ADD_MULTIPLIED_BASE)));
    }
}

