/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.effect;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.effect.TombstoneEffect;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.registry.ModDamages;

public final class DecrepitudeEffect
extends TombstoneEffect {
    private static final String DECREPITUDE_APPLIER = "decrepitude_applier";

    public DecrepitudeEffect() {
        super(MobEffectCategory.HARMFUL, -8835971);
        this.addAttributeModifier(Attributes.MOVEMENT_SPEED, ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"decrepitude_movement_speed"), -0.15, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
        this.noAttributeScale();
    }

    @Override
    public void onEffectStarted(LivingEntity livingEntity, int amplifier) {
        super.onEffectStarted(livingEntity, amplifier);
        if (!livingEntity.level().isClientSide() && livingEntity.isAlive()) {
            LivingEntity livingEntity2;
            CompoundTag tag = livingEntity.getPersistentData();
            if (livingEntity.getLastHurtByMobTimestamp() == livingEntity.tickCount && (livingEntity2 = livingEntity.getLastHurtByMob()) instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)livingEntity2;
                tag.putUUID(DECREPITUDE_APPLIER, serverPlayer.getUUID());
            } else {
                tag.remove(DECREPITUDE_APPLIER);
            }
        }
    }

    @Override
    public void onEffectFinished(LivingEntity livingEntity, MobEffectInstance effectInstance) {
        CompoundTag tag;
        super.onEffectFinished(livingEntity, effectInstance);
        if (!livingEntity.level().isClientSide() && livingEntity.isAlive() && (tag = livingEntity.getPersistentData()).contains(DECREPITUDE_APPLIER)) {
            tag.remove(DECREPITUDE_APPLIER);
        }
    }

    public boolean applyEffectTick(LivingEntity livingEntity, int amplifier) {
        if (!livingEntity.level().isClientSide()) {
            ServerPlayer player;
            MinecraftServer server;
            LivingEntity attacker = livingEntity;
            CompoundTag tag = livingEntity.getPersistentData();
            if (tag.contains(DECREPITUDE_APPLIER) && (server = livingEntity.getServer()) != null && (player = server.getPlayerList().getPlayer(tag.getUUID(DECREPITUDE_APPLIER))) != null) {
                attacker = player;
            }
            Helper.hurtWithoutCooldown(livingEntity, ModDamages.sourceUnholy((Entity)attacker), Math.min((float)((Integer)ConfigTombstone.general.decrepitudeMaxDamage.get()).intValue(), Math.min((float)(amplifier + 1) * 0.01f, 0.4f) * livingEntity.getMaxHealth()));
        }
        return true;
    }

    @Override
    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return duration % 40 == 0;
    }
}

