/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.entity.ai;

import java.util.EnumSet;
import java.util.Optional;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;

public abstract class OwnerHurtTargetGoal
extends TargetGoal {
    private LivingEntity ownerLastHurt;
    private int timestamp;

    public OwnerHurtTargetGoal(Mob servant) {
        super(servant, false);
        this.setFlags(EnumSet.of(Goal.Flag.TARGET));
    }

    public boolean canUse() {
        return this.getOwner().map(owner -> {
            this.ownerLastHurt = owner.getLastHurtMob();
            int lastHurtMobTimestamp = owner.getLastHurtMobTimestamp();
            if (this.timestamp != lastHurtMobTimestamp && this.canAttack(this.ownerLastHurt, TargetingConditions.DEFAULT)) {
                this.timestamp = lastHurtMobTimestamp;
                return true;
            }
            return false;
        }).orElse(false);
    }

    public void start() {
        this.mob.setTarget(this.ownerLastHurt);
        this.mob.setLastHurtByMob(this.ownerLastHurt);
        super.start();
    }

    protected abstract Optional<Player> getOwner();
}

