/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.entity.ai.spell;

import javax.annotation.Nullable;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.PathfinderMob;
import ovh.corail.tombstone.entity.ai.spell.SpellUseGoal;

public class SelfBuffSpellGoal
extends SpellUseGoal {
    protected final MobEffectInstance mobEffectInstance;

    public SelfBuffSpellGoal(PathfinderMob caster, MobEffectInstance mobEffectInstance) {
        super(caster);
        this.mobEffectInstance = mobEffectInstance;
    }

    @Override
    public boolean canUse() {
        return super.canUse() && !this.caster.hasEffect(this.mobEffectInstance.getEffect());
    }

    @Override
    protected void performSpellCasting() {
        this.caster.addEffect(new MobEffectInstance(this.mobEffectInstance));
    }

    @Override
    protected int getCastWarmupTime() {
        return 10;
    }

    @Override
    protected int getCastingTime() {
        return 20;
    }

    @Override
    protected int getCastingInterval() {
        return this.mobEffectInstance.getDuration();
    }

    @Override
    @Nullable
    protected SoundEvent getSpellPrepareSound() {
        return SoundEvents.ILLUSIONER_PREPARE_MIRROR;
    }

    @Override
    protected int getSpellColor() {
        return ((MobEffect)this.mobEffectInstance.getEffect().value()).getColor() & 0xFFFFFF;
    }
}

