/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.gui;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Stack;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.gui.TBScreen;
import ovh.corail.tombstone.helper.FontHelper;

@OnlyIn(value=Dist.CLIENT)
public class ScreenReadableScroll
extends TBScreen {
    private static final ResourceLocation BACKGROUND = ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"textures/gui/scroll.png");
    private static final ResourceLocation ARROW_UP = ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"textures/gui/arrow-up.png");
    private static final ResourceLocation ARROW_DOWN = ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"textures/gui/arrow-down.png");
    private static final Pattern TAG_PATTERN = Pattern.compile("\\[(/?)(b|i|c(?:=#[0-9a-fA-F]{6})?)\\]");
    private static final int VISIBLE_LINES = 15;
    private final List<FormattedCharSequence> lines = new ArrayList<FormattedCharSequence>();
    private int scrollOffset = 0;
    private final int textWidth = 180;

    public ScreenReadableScroll(String contentId, int contentPart) {
        super((Component)Component.literal((String)"Readable Scroll"), 380, 250);
        this.initScroll(contentId + "_" + contentPart);
    }

    @Override
    protected ResourceLocation getBackground() {
        return BACKGROUND;
    }

    @Override
    protected boolean hasWhiteBorder() {
        return false;
    }

    private void initScroll(String fileName) {
        CompletableFuture.runAsync(() -> {
            Minecraft mc = Minecraft.getInstance();
            String langCode = mc.options.languageCode;
            String prefix = "/assets/tombstone/text/" + fileName + "_";
            InputStream input = null;
            if (!"en_us".equals(langCode) && (input = ModTombstone.class.getResourceAsStream(prefix + langCode + ".txt")) == null && langCode.contains("_")) {
                String baseLang = langCode.split("_")[0];
                input = ModTombstone.class.getResourceAsStream(prefix + baseLang + "_" + baseLang + ".txt");
            }
            if (input == null) {
                input = ModTombstone.class.getResourceAsStream(prefix + "en_us.txt");
            }
            if (input == null) {
                mc.execute(() -> ModTombstone.LOGGER.error("File not found: {}_en_us.txt", (Object)fileName));
                return;
            }
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));){
                String line;
                StringBuilder stringBuilder = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    stringBuilder.append(line).append("\n");
                }
                mc.execute(() -> this.lines.addAll(mc.font.split((FormattedText)FontHelper.withFantasyFont(this.parse(stringBuilder.toString())), 180)));
            }
            catch (IOException e) {
                mc.execute(() -> ModTombstone.LOGGER.error("Unable to read scroll: '{}'", (Object)fileName, (Object)e));
            }
        });
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (scrollY < 0.0) {
            this.scrollOffset = Math.min(this.scrollOffset + 1, Math.max(0, this.lines.size() - 15));
        } else if (scrollY > 0.0) {
            this.scrollOffset = Math.max(this.scrollOffset - 1, 0);
        }
        return true;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.isResized) {
            return;
        }
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        if (this.scrollOffset > 0) {
            guiGraphics.blit(ARROW_UP, this.width / 2 - 5, this.guiTop + 50, 0.0f, 0.0f, 10, 7, 10, 7);
        }
        int x = this.guiLeft + 95;
        int y = this.guiTop + 60;
        for (int i = 0; i < 15 && i + this.scrollOffset < this.lines.size(); ++i) {
            FormattedCharSequence line = this.lines.get(i + this.scrollOffset);
            Objects.requireNonNull(this.font);
            guiGraphics.drawString(this.font, line, x, y + i * 9, -1875, true);
        }
        if (this.scrollOffset < this.lines.size() - 15) {
            guiGraphics.blit(ARROW_DOWN, this.width / 2 - 5, this.guiTop + 200, 0.0f, 0.0f, 10, 7, 10, 7);
        }
    }

    public Component parse(String input) {
        MutableComponent result = Component.empty();
        Stack<Style> styles = new Stack<Style>();
        styles.push(Style.EMPTY);
        Matcher matcher = TAG_PATTERN.matcher(input);
        int lastIndex = 0;
        while (matcher.find()) {
            int start = matcher.start();
            int end = matcher.end();
            String preText = input.substring(lastIndex, start);
            if (!preText.isEmpty()) {
                result.append((Component)Component.literal((String)preText).setStyle((Style)styles.peek()));
            }
            String isClosing = matcher.group(1);
            String tag = matcher.group(2);
            if (isClosing.isEmpty()) {
                String hex;
                Optional color;
                Style updated = (Style)styles.peek();
                if ("b".equals(tag)) {
                    updated = updated.withBold(Boolean.valueOf(true));
                } else if ("i".equals(tag)) {
                    updated = updated.withItalic(Boolean.valueOf(true));
                } else if (tag.startsWith("c=#") && (color = TextColor.parseColor((String)(hex = tag.substring(tag.indexOf(35)))).result()).isPresent()) {
                    updated = updated.withColor((TextColor)color.get());
                }
                styles.push(updated);
            } else if (styles.size() > 1) {
                styles.pop();
            } else {
                ModTombstone.LOGGER.error("Excessive tag closure : " + tag);
            }
            lastIndex = end;
        }
        if (lastIndex < input.length()) {
            result.append((Component)Component.literal((String)input.substring(lastIndex)).setStyle((Style)styles.peek()));
        }
        return result;
    }
}

