/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.saveddata.SavedData;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.level.BlockEvent;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.registry.ModTags;

public class PlacedBlocksTracker
extends SavedData {
    private final Set<BlockPos> placedBlocks = ConcurrentHashMap.newKeySet();
    public boolean isValidBlock = false;
    private static final SavedData.Factory<PlacedBlocksTracker> FACTORY = new SavedData.Factory(PlacedBlocksTracker::new, PlacedBlocksTracker::load);

    public void add(BlockPos pos) {
        this.placedBlocks.add(pos.immutable());
        this.setDirty();
    }

    public void remove(BlockPos pos) {
        this.placedBlocks.remove(pos);
        this.setDirty();
    }

    public boolean contains(BlockPos pos) {
        return this.placedBlocks.contains(pos);
    }

    public CompoundTag save(CompoundTag tag, HolderLookup.Provider registries) {
        ListTag list = new ListTag();
        for (BlockPos pos : this.placedBlocks) {
            CompoundTag posTag = new CompoundTag();
            posTag.putInt("x", pos.getX());
            posTag.putInt("y", pos.getY());
            posTag.putInt("z", pos.getZ());
            list.add((Object)posTag);
        }
        tag.put("placed_blocks", (Tag)list);
        return tag;
    }

    public static PlacedBlocksTracker load(CompoundTag tag, HolderLookup.Provider provider) {
        PlacedBlocksTracker tracker = new PlacedBlocksTracker();
        ListTag list = NBTStackHelper.getListOrCreate(tag, "placed_blocks");
        for (Tag t : list) {
            CompoundTag posTag = (CompoundTag)t;
            BlockPos pos = new BlockPos(posTag.getInt("x"), posTag.getInt("y"), posTag.getInt("z"));
            tracker.placedBlocks.add(pos.immutable());
        }
        return tracker;
    }

    public static PlacedBlocksTracker get(ServerLevel level) {
        return (PlacedBlocksTracker)level.getDataStorage().computeIfAbsent(FACTORY, "tb_placed_blocks_tracker");
    }

    @EventBusSubscriber(modid="tombstone", bus=EventBusSubscriber.Bus.GAME)
    public static class PlacedBlocksEvents {
        @SubscribeEvent(priority=EventPriority.LOWEST)
        public static void onPlacedBlock(BlockEvent.EntityPlaceEvent event) {
            LevelAccessor levelAccessor;
            if (event.getBlockSnapshot().getLevel() != null && (levelAccessor = event.getBlockSnapshot().getLevel()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)levelAccessor;
                if (PlacedBlocksEvents.isTrackedBlock(event.getPlacedBlock())) {
                    PlacedBlocksTracker tracker = PlacedBlocksTracker.get(serverLevel);
                    if (tracker.isValidBlock) {
                        tracker.isValidBlock = false;
                    } else {
                        tracker.add(event.getPos());
                    }
                }
            }
        }

        @SubscribeEvent(priority=EventPriority.LOWEST)
        public static void onBrokenBlock(BlockEvent.BreakEvent event) {
            PlacedBlocksTracker tracker;
            if (!event.getPlayer().level().isClientSide && PlacedBlocksEvents.isTrackedBlock(event.getState()) && (tracker = PlacedBlocksTracker.get((ServerLevel)event.getPlayer().level())).contains(event.getPos())) {
                tracker.remove(event.getPos());
            }
        }

        private static boolean isTrackedBlock(BlockState state) {
            return state.is(ModTags.Blocks.living_corals) || state.is(ModTags.Blocks.dead_corals);
        }
    }
}

