/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.GlobalClock;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.ProxyHelper;
import ovh.corail.tombstone.helper.TamableType;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.item.IDefaultImpregnable;
import ovh.corail.tombstone.item.ItemGeneric;
import ovh.corail.tombstone.registry.ModDataComponents;
import ovh.corail.tombstone.registry.ModTriggers;

public class ItemBoneNeedle
extends ItemGeneric
implements IDefaultImpregnable {
    private static final int IMPREGNATED_MAX_TIME = TimeHelper.tickFromHour(1);

    public ItemBoneNeedle() {
        super("bone_needle", ItemBoneNeedle.getBuilder().stacksTo(1));
    }

    @Override
    protected void addTooltipInfo(ItemStack stack, Item.TooltipContext context, List<Component> tooltip) {
        this.addItemDesc(tooltip);
        Component impregnated = this.getTooltipDisplay(stack);
        if (impregnated == null) {
            this.addItemUse(tooltip);
        } else {
            tooltip.add(impregnated);
        }
        int impregnatedTime = ProxyHelper.getClientWorld().map(level -> this.getImpregnatedTime((Level)level, stack)).orElse(0);
        if (impregnatedTime > 0) {
            this.addWarn(tooltip, LangKey.MESSAGE_IMPREGNATE_DURATION, TimeHelper.getTimeStringWithUnit(impregnatedTime));
        }
        super.addTooltipInfo(stack, context, tooltip);
    }

    public ItemStack withRandomImpregnation(ItemStack stack) {
        if (stack.is((Item)this)) {
            this.impregnate(stack, TamableType.getRandomSummonableEntityType().toString());
        }
        return stack;
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player player, LivingEntity target, InteractionHand hand) {
        if (hand == InteractionHand.MAIN_HAND && stack.is((Item)this) && EntityHelper.noGlobalItemCooldown(player, this)) {
            EntityHelper.setGlobalItemCooldown(player, this, 10);
            if (!player.level().isClientSide()) {
                if (this.impregnate(stack, target)) {
                    ModDataComponents.setTimer(stack, ModDataComponents.COOLDOWN_TIME, GlobalClock.INSTANCE.getTime(player.level()) + (long)IMPREGNATED_MAX_TIME);
                    LangKey.MESSAGE_IMPREGNATE_NEEDLE_SUCCESS.sendSpecialMessage(player, target.getName());
                    ModTriggers.impregnated_bone_needle.trigger((ServerPlayer)player);
                } else {
                    LangKey.MESSAGE_IMPREGNATE_NEEDLE_FAILED.sendSpecialMessage(player, new Object[0]);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        if (!level.isClientSide() && stack.is((Item)this) && EntityHelper.isValidPlayer(entity) && !this.getEntityType(stack).isEmpty() && this.getImpregnatedTime(level, stack) == 1) {
            stack.remove(ModDataComponents.COOLDOWN_TIME);
            stack.remove(ModDataComponents.ENTITY_TYPE);
        }
    }

    private int getImpregnatedTime(@Nullable Level level, ItemStack stack) {
        return level != null && stack.is((Item)this) ? ModDataComponents.getTimer(GlobalClock.INSTANCE.getTime(level), stack, ModDataComponents.COOLDOWN_TIME, IMPREGNATED_MAX_TIME) : 0;
    }
}

