/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import ovh.corail.tombstone.api.item.ISoulConsumer;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.item.ItemBook;
import ovh.corail.tombstone.registry.ModTriggers;

public class ItemBookOfMagicImpregnation
extends ItemBook {
    public ItemBookOfMagicImpregnation() {
        super("book_of_magic_impregnation", () -> SharedConfigTombstone.allowed_magic_items.allowBookOfMagicImpregnation.get());
    }

    @Override
    public ISoulConsumer.ConsumeResult setEnchant(Level level, BlockPos gravePos, ServerPlayer player, ItemStack stack, int soulStrength) {
        int consumed;
        ItemStack mainhand;
        if (stack.getItem() != this || (mainhand = player.getMainHandItem()).isEmpty()) {
            return ISoulConsumer.ConsumeResult.fail((Component)LangKey.MESSAGE_MAGIC_IMPREGNATION_FAILED.getText(new Object[0]));
        }
        if (mainhand.is(Items.ARROW)) {
            consumed = soulStrength;
            player.setItemSlot(EquipmentSlot.MAINHAND, soulStrength == 1 ? EffectHelper.createRandomArrows(mainhand.getCount()) : EffectHelper.createCursedArrows(mainhand.getCount()));
            ModTriggers.create_imbued_arrow.trigger(player);
        } else {
            ItemEnchantments itemEnchantments = EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)mainhand);
            if (itemEnchantments.isEmpty()) {
                int enchantability = mainhand.getEnchantmentValue();
                if (enchantability > 0 && mainhand.getItem().isEnchantable(mainhand) && !mainhand.has(DataComponents.ENCHANTMENTS)) {
                    mainhand.set(DataComponents.ENCHANTMENTS, (Object)ItemEnchantments.EMPTY);
                }
                if (!mainhand.isEnchantable() || enchantability == 0) {
                    return ISoulConsumer.ConsumeResult.fail((Component)LangKey.MESSAGE_MAGIC_IMPREGNATION_FAILED.getText(new Object[0]));
                }
                consumed = soulStrength;
                int enchantmentCount = soulStrength > 1 ? 6 : 3;
                itemEnchantments = Helper.getRandomEnchantments(enchantability + Helper.RANDOM.nextInt(soulStrength * 30), mainhand, enchantmentCount, level);
                if (mainhand.is(Items.BOOK)) {
                    mainhand = new ItemStack((ItemLike)Items.ENCHANTED_BOOK);
                    player.setItemSlot(EquipmentSlot.MAINHAND, mainhand);
                }
                EnchantmentHelper.setEnchantments((ItemStack)mainhand, (ItemEnchantments)itemEnchantments);
            } else {
                List<Object2IntMap.Entry> upgradables = itemEnchantments.entrySet().stream().filter(e -> Helper.getMaxLevel((Holder<Enchantment>)((Holder)e.getKey())) > e.getIntValue()).toList();
                if (upgradables.isEmpty()) {
                    return ISoulConsumer.ConsumeResult.fail((Component)LangKey.MESSAGE_MAGIC_IMPREGNATION_MAX.getText(new Object[0]));
                }
                if (soulStrength == 1 || upgradables.size() == 1) {
                    consumed = 1;
                    EnchantmentHelper.updateEnchantments((ItemStack)mainhand, stackEnchantment -> {
                        Object2IntMap.Entry entry = (Object2IntMap.Entry)upgradables.get(Helper.RANDOM.nextInt(upgradables.size()));
                        stackEnchantment.upgrade((Holder)entry.getKey(), Math.min(entry.getIntValue() + 3, Helper.getMaxLevel((Holder<Enchantment>)((Holder)entry.getKey()))));
                    });
                } else {
                    consumed = 2;
                    for (Object2IntMap.Entry entry : upgradables) {
                        if (Helper.getMaxLevel((Holder<Enchantment>)((Holder)entry.getKey())) <= entry.getIntValue()) continue;
                        EnchantmentHelper.updateEnchantments((ItemStack)mainhand, stackEnchantment -> stackEnchantment.upgrade((Holder)entry.getKey(), Math.min(entry.getIntValue() + 3, Helper.getMaxLevel((Holder<Enchantment>)((Holder)entry.getKey())))));
                    }
                }
            }
        }
        stack.shrink(1);
        ModTriggers.use_magic_impregnation.trigger(player);
        return ISoulConsumer.ConsumeResult.success((Component)LangKey.MESSAGE_MAGIC_IMPREGNATION_SUCCESS.getText(new Object[0]), consumed);
    }
}

