/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import ovh.corail.tombstone.api.item.ISoulConsumer;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.item.ItemBook;
import ovh.corail.tombstone.registry.ModDataComponents;
import ovh.corail.tombstone.registry.ModTriggers;

public class ItemBookOfSoulbound
extends ItemBook {
    public ItemBookOfSoulbound() {
        super("book_of_soulbound", () -> SharedConfigTombstone.allowed_magic_items.allowBookOfSoulbound.get());
    }

    @Override
    public ISoulConsumer.ConsumeResult setEnchant(Level level, BlockPos gravePos, ServerPlayer player, ItemStack stack, int soulStrength) {
        ItemStack mainhand;
        if (stack.getItem() != this || (mainhand = player.getMainHandItem()).isEmpty() || mainhand.getMaxStackSize() != 1) {
            return ISoulConsumer.ConsumeResult.fail((Component)LangKey.MESSAGE_SOULBOUND_FAILED.getText(new Object[0]));
        }
        if (Helper.isSoulbound(mainhand, level)) {
            return ISoulConsumer.ConsumeResult.fail((Component)LangKey.MESSAGE_ENCHANT_ITEM_ALREADY_ENCHANTED.getText(new Object[0]));
        }
        mainhand.set(ModDataComponents.SOULBOUND, (Object)true);
        stack.shrink(1);
        ModTriggers.use_soulbound.trigger(player);
        return ISoulConsumer.ConsumeResult.success((Component)LangKey.MESSAGE_SOULBOUND_SUCCESS.getText(new Object[0]), 1);
    }
}

