/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import ovh.corail.tombstone.helper.ProxyHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.item.ItemGeneric;
import ovh.corail.tombstone.registry.ModDataComponents;

public class ItemReadableScroll
extends ItemGeneric {
    public ItemReadableScroll() {
        super("readable_scroll", ItemReadableScroll.getBuilder().stacksTo(1).fireResistant());
    }

    @Override
    protected void addTooltipInfo(ItemStack stack, Item.TooltipContext context, List<Component> tooltip) {
        MutableComponent author = Component.translatable((String)("readable_scroll." + this.getContentId(stack) + ".author"));
        if (!author.getString().isEmpty()) {
            tooltip.add((Component)Component.translatable((String)"readable_scroll.by_author", (Object[])new Object[]{author}).setStyle(StyleType.INFO));
        }
        tooltip.add((Component)Component.translatable((String)"readable_scroll.read_info").setStyle(StyleType.TOOLTIP_USE));
        super.addTooltipInfo(stack, context, tooltip);
    }

    @Override
    public void fillItemCategory(CreativeModeTab.Output toAdd) {
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        if (!level.isClientSide() && stack.is((Item)this) && TimeHelper.atInterval(level, 100) && this.getContentId(stack).isEmpty()) {
            stack.shrink(1);
        }
    }

    public Component getName(ItemStack stack) {
        return Component.translatable((String)"readable_scroll.title", (Object[])new Object[]{Component.translatable((String)("readable_scroll." + this.getContentId(stack) + ".title")), this.getContentPart(stack)}).setStyle(StyleType.MESSAGE_SPECIAL);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack;
        if (level.isClientSide && (stack = player.getItemInHand(hand)).is((Item)this)) {
            ProxyHelper.openReadableScrollScreen(this.getContentId(stack), this.getContentPart(stack));
        }
        return InteractionResultHolder.sidedSuccess((Object)player.getItemInHand(hand), (boolean)level.isClientSide());
    }

    public boolean isEnchantable(ItemStack stack) {
        return false;
    }

    public ItemStack createScroll(String title, int part) {
        ItemStack stack = new ItemStack((ItemLike)this);
        this.setContent(stack, title, part);
        return stack;
    }

    public void setContent(ItemStack stack, String title, int part) {
        stack.set(ModDataComponents.CONTENT_ID, (Object)title);
        stack.set(ModDataComponents.CONTENT_PART, (Object)part);
    }

    public String getContentId(ItemStack stack) {
        return (String)stack.getOrDefault(ModDataComponents.CONTENT_ID, (Object)"");
    }

    public int getContentPart(ItemStack stack) {
        return (Integer)stack.getOrDefault(ModDataComponents.CONTENT_PART, (Object)1);
    }
}

