/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.mixin;

import net.minecraft.core.Holder;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.neoforged.neoforge.common.extensions.IItemStackExtension;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.registry.ModDataComponents;
import ovh.corail.tombstone.registry.ModEnchantments;

@Mixin(value={IItemStackExtension.class}, priority=1031, remap=false)
public interface ItemStackExtensionMixin {
    @Inject(method={"isPrimaryItemFor"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void methodIsPrimaryItemFor(Holder<Enchantment> enchantmentHolder, CallbackInfoReturnable<Boolean> callbackInfoReturnable) {
        if (enchantmentHolder.is(ModEnchantments.soulbound)) {
            ItemStack stack;
            if (!((Boolean)SharedConfigTombstone.enchantments.soulboundEnchantingTable.get()).booleanValue()) {
                callbackInfoReturnable.setReturnValue((Object)false);
            }
            if ((stack = (ItemStack)this).getMaxStackSize() == 1) {
                callbackInfoReturnable.setReturnValue((Object)((Boolean)stack.getOrDefault(ModDataComponents.SOULBOUND, (Object)false) == false ? 1 : 0));
            }
        } else if (enchantmentHolder.is(ModEnchantments.magic_siphon)) {
            if (!((Boolean)SharedConfigTombstone.enchantments.magicSiphonEnchantingTable.get()).booleanValue()) {
                callbackInfoReturnable.setReturnValue((Object)false);
            }
        } else if (enchantmentHolder.is(ModEnchantments.plague_bringer)) {
            if (!((Boolean)SharedConfigTombstone.enchantments.plagueBringerEnchantingTable.get()).booleanValue()) {
                callbackInfoReturnable.setReturnValue((Object)false);
            }
        } else if (enchantmentHolder.is(ModEnchantments.curse_of_bones)) {
            if (!((Boolean)SharedConfigTombstone.enchantments.curseOfBonesEnchantingTable.get()).booleanValue()) {
                callbackInfoReturnable.setReturnValue((Object)false);
            }
        } else if (enchantmentHolder.is(ModEnchantments.blessing)) {
            if (!((Boolean)SharedConfigTombstone.enchantments.blessingEnchantingTable.get()).booleanValue()) {
                callbackInfoReturnable.setReturnValue((Object)false);
            }
        } else if (enchantmentHolder.is(ModEnchantments.frostbite)) {
            if (!((Boolean)SharedConfigTombstone.enchantments.frostbiteEnchantingTable.get()).booleanValue()) {
                callbackInfoReturnable.setReturnValue((Object)false);
            }
        } else if (enchantmentHolder.is(ModEnchantments.spectral_bite)) {
            if (!((Boolean)SharedConfigTombstone.enchantments.spectralBiteEnchantingTable.get()).booleanValue()) {
                callbackInfoReturnable.setReturnValue((Object)false);
            }
        } else if (enchantmentHolder.is(ModEnchantments.spectral_conjurer)) {
            if (!((Boolean)SharedConfigTombstone.enchantments.spectralConjurerEnchantingTable.get()).booleanValue()) {
                callbackInfoReturnable.setReturnValue((Object)false);
            }
        } else if (enchantmentHolder.is(ModEnchantments.incurable_wounds)) {
            if (!((Boolean)SharedConfigTombstone.enchantments.incurableWoundsEnchantingTable.get()).booleanValue()) {
                callbackInfoReturnable.setReturnValue((Object)false);
            }
        } else if (enchantmentHolder.is(ModEnchantments.decrepitude)) {
            if (!((Boolean)SharedConfigTombstone.enchantments.decrepitudeEnchantingTable.get()).booleanValue()) {
                callbackInfoReturnable.setReturnValue((Object)false);
            }
        } else if (enchantmentHolder.is(ModEnchantments.sanctified)) {
            if (!((Boolean)SharedConfigTombstone.enchantments.sanctifiedEnchantingTable.get()).booleanValue()) {
                callbackInfoReturnable.setReturnValue((Object)false);
            }
        } else if (enchantmentHolder.is(ModEnchantments.ruthless_strike) && !((Boolean)SharedConfigTombstone.enchantments.ruthlessStrikeEnchantingTable.get()).booleanValue()) {
            callbackInfoReturnable.setReturnValue((Object)false);
        }
    }

    @Inject(method={"supportsEnchantment"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void methodSupportsEnchantment(Holder<Enchantment> enchantmentHolder, CallbackInfoReturnable<Boolean> callbackInfoReturnable) {
        ItemStack stack;
        if (enchantmentHolder.is(ModEnchantments.soulbound) && (stack = (ItemStack)this).getMaxStackSize() == 1) {
            callbackInfoReturnable.setReturnValue((Object)((Boolean)stack.getOrDefault(ModDataComponents.SOULBOUND, (Object)false) == false ? 1 : 0));
        }
    }
}

