/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.particle;

import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.particle.BoundParticle;
import ovh.corail.tombstone.particle.ParticleBlinkingAura;
import ovh.corail.tombstone.particle.ParticleRenderTypes;

@OnlyIn(value=Dist.CLIENT)
public final class ParticleRounding
extends BoundParticle {
    private final Type type;
    private final int count;
    private final double height;
    @Nullable
    private final Predicate<LivingEntity> requireRemoval;

    public ParticleRounding(ClientLevel level, LivingEntity entity, Type type) {
        this(level, entity, type, null);
    }

    public ParticleRounding(ClientLevel level, LivingEntity entity, Type type, @Nullable Predicate<LivingEntity> requireRemoval) {
        super(level, entity, entity.getBbWidth());
        this.type = type;
        this.count = Mth.ceil((float)(entity.getBbWidth() * ((float)Math.PI * 2)));
        this.height = type.heightProvider.apply(entity);
        this.requireRemoval = requireRemoval;
        if (this.type.rolling) {
            this.setRolling(0.31415927f);
        }
    }

    @Override
    protected void addParticleDatas(List<BoundParticle.ParticleData> datas) {
        IntStream.range(0, this.count).forEach(part -> datas.add(new BoundParticle.ParticleData(this, this.type.size, (double)part / (double)this.count, this.height, this.type.rolling ? (part % 2 == 0 ? 0.0f : (float)Math.PI) : 0.0f)));
    }

    @Override
    protected boolean requireRemoval() {
        return this.requireRemoval != null ? Optional.ofNullable((LivingEntity)this.entityWeakReference.get()).map(this.requireRemoval::test).orElse(true).booleanValue() : super.requireRemoval();
    }

    @Override
    protected void onParticleDataUpdate(BoundParticle.ParticleData data, double ratio) {
        super.onParticleDataUpdate(data, ratio);
        if (this.type == Type.BONE) {
            ParticleBlinkingAura part = new ParticleBlinkingAura(this.level, data.pos.x, data.pos.y, data.pos.z, 1.0f, 0.8f, Helper.RANDOM.nextFloat() + 0.5f);
            part.setAlpha(0.15f);
            part.scale(2.5f);
            Minecraft.getInstance().particleEngine.add((Particle)part);
        }
    }

    public ParticleRenderType getRenderType() {
        return switch (this.type.ordinal()) {
            case 0 -> ParticleRenderTypes.HEART;
            case 1 -> ParticleRenderTypes.SHIELD;
            case 2 -> ParticleRenderTypes.BONE;
            case 3 -> ParticleRenderTypes.ANKH;
            case 4 -> ParticleRenderTypes.GHAST_TEAR;
            case 5 -> ParticleRenderTypes.GOLD_HEART;
            default -> ParticleRenderTypes.BLACK_NOTE;
        };
    }

    public static enum Type {
        HEART(0.6f, false),
        SHIELD(1.0f, false, entity -> 0.3),
        BONE(1.0f, true, entity -> 0.3),
        ANKH(1.0f, false),
        GHAST_TEAR(1.0f, false),
        GOLD_HEART(0.6f, false),
        BLACK_NOTE(1.0f, false);

        private final float size;
        private final boolean rolling;
        private final Function<LivingEntity, Double> heightProvider;

        private Type(float size, boolean rolling) {
            this(size, rolling, entity -> (double)entity.getBbHeight() / 4.0);
        }

        private Type(float size, boolean rolling, Function<LivingEntity, Double> heightProvider) {
            this.size = size;
            this.rolling = rolling;
            this.heightProvider = heightProvider;
        }

        public static Type byId(int id) {
            return Type.values()[Mth.clamp((int)id, (int)0, (int)(Type.values().length - 1))];
        }
    }
}

